// third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_INTRINSIC_SIZING_INFO_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_INTRINSIC_SIZING_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class IntrinsicSizingInfoDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::IntrinsicSizingInfoDataView> {
  using Data = ::blink::mojom::internal::IntrinsicSizingInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


class IntrinsicSizingInfoDataView {
 public:
  IntrinsicSizingInfoDataView() {}

  IntrinsicSizingInfoDataView(
      internal::IntrinsicSizingInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSize(UserType* output) {
    
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        pointer, output, context_);
  }
  inline void GetAspectRatioDataView(
      ::gfx::mojom::SizeFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAspectRatio(UserType* output) {
    
    auto* pointer = data_->aspect_ratio.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        pointer, output, context_);
  }
  bool has_width() const {
    return data_->has_width;
  }
  bool has_height() const {
    return data_->has_height;
  }
 private:
  internal::IntrinsicSizingInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IntrinsicSizingInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IntrinsicSizingInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::IntrinsicSizingInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::size(input)) in_size = Traits::size(input);
    typename decltype((*output)->size)::BaseType::BufferWriter
        size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
        in_size, buffer, &size_writer, context);
    (*output)->size.Set(
        size_writer.is_null() ? nullptr : size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null size in IntrinsicSizingInfo struct");
    decltype(Traits::aspect_ratio(input)) in_aspect_ratio = Traits::aspect_ratio(input);
    typename decltype((*output)->aspect_ratio)::BaseType::BufferWriter
        aspect_ratio_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
        in_aspect_ratio, buffer, &aspect_ratio_writer, context);
    (*output)->aspect_ratio.Set(
        aspect_ratio_writer.is_null() ? nullptr : aspect_ratio_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->aspect_ratio.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aspect_ratio in IntrinsicSizingInfo struct");
    (*output)->has_width = Traits::has_width(input);
    (*output)->has_height = Traits::has_height(input);
  }

  static bool Deserialize(::blink::mojom::internal::IntrinsicSizingInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IntrinsicSizingInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void IntrinsicSizingInfoDataView::GetSizeDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->size.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, context_);
}
inline void IntrinsicSizingInfoDataView::GetAspectRatioDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->aspect_ratio.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_INTRINSIC_SIZING_INFO_MOJOM_SHARED_H_