// third_party/blink/public/mojom/input/touch_event.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_TOUCH_EVENT_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_TOUCH_EVENT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/input/touch_event.mojom-shared.h"
#include "third_party/blink/public/mojom/input/touch_event.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"




namespace WTF {
struct blink_mojom_internal_TouchState_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::TouchState& value) {
    using utype = std::underlying_type<::blink::mojom::TouchState>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::TouchState& left, const ::blink::mojom::TouchState& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::TouchState>
    : public GenericHashTraits<::blink::mojom::TouchState> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::TouchState& value) {
    return value == static_cast<::blink::mojom::TouchState>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::TouchState& slot, bool) {
    slot = static_cast<::blink::mojom::TouchState>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::TouchState& value) {
    return value == static_cast<::blink::mojom::TouchState>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {





class PLATFORM_EXPORT TouchEventConsumers {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TouchEventConsumers, T>::value>;
  using DataView = TouchEventConsumersDataView;
  using Data_ = internal::TouchEventConsumers_Data;

  template <typename... Args>
  static TouchEventConsumersPtr New(Args&&... args) {
    return TouchEventConsumersPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TouchEventConsumersPtr From(const U& u) {
    return mojo::TypeConverter<TouchEventConsumersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TouchEventConsumers>::Convert(*this);
  }


  TouchEventConsumers();

  TouchEventConsumers(
      bool has_touch_event_handlers,
      bool has_hit_testable_scrollbar);

  ~TouchEventConsumers();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TouchEventConsumersPtr>
  TouchEventConsumersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TouchEventConsumers::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TouchEventConsumers::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TouchEventConsumers::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TouchEventConsumers_UnserializedMessageContext<
            UserType, TouchEventConsumers::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TouchEventConsumers::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return TouchEventConsumers::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TouchEventConsumers_UnserializedMessageContext<
            UserType, TouchEventConsumers::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TouchEventConsumers::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool has_touch_event_handlers;
  
  bool has_hit_testable_scrollbar;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TouchEventConsumers::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TouchEventConsumers::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TouchEventConsumers::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TouchEventConsumers::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
TouchEventConsumersPtr TouchEventConsumers::Clone() const {
  return New(
      mojo::Clone(has_touch_event_handlers),
      mojo::Clone(has_hit_testable_scrollbar)
  );
}

template <typename T, TouchEventConsumers::EnableIfSame<T>*>
bool TouchEventConsumers::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->has_touch_event_handlers, other_struct.has_touch_event_handlers))
    return false;
  if (!mojo::Equals(this->has_hit_testable_scrollbar, other_struct.has_hit_testable_scrollbar))
    return false;
  return true;
}

template <typename T, TouchEventConsumers::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.has_touch_event_handlers, rhs.has_touch_event_handlers))
    return true;
  if (std::less<>{}(rhs.has_touch_event_handlers, lhs.has_touch_event_handlers))
    return false;
  if (std::less<>{}(lhs.has_hit_testable_scrollbar, rhs.has_hit_testable_scrollbar))
    return true;
  if (std::less<>{}(rhs.has_hit_testable_scrollbar, lhs.has_hit_testable_scrollbar))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::TouchEventConsumers::DataView,
                                         ::blink::mojom::blink::TouchEventConsumersPtr> {
  static bool IsNull(const ::blink::mojom::blink::TouchEventConsumersPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::TouchEventConsumersPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::TouchEventConsumers::has_touch_event_handlers) has_touch_event_handlers(
      const ::blink::mojom::blink::TouchEventConsumersPtr& input) {
    return input->has_touch_event_handlers;
  }

  static decltype(::blink::mojom::blink::TouchEventConsumers::has_hit_testable_scrollbar) has_hit_testable_scrollbar(
      const ::blink::mojom::blink::TouchEventConsumersPtr& input) {
    return input->has_hit_testable_scrollbar;
  }

  static bool Read(::blink::mojom::blink::TouchEventConsumers::DataView input, ::blink::mojom::blink::TouchEventConsumersPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_TOUCH_EVENT_MOJOM_BLINK_H_