// third_party/blink/public/mojom/mediasession/media_session.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/mediasession/media_session.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/media_session/public/mojom/media_session.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class MediaSessionSeekToDetailsDataView;

class SpecMediaMetadataDataView;

class MediaSessionActionDetailsDataView;


}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::MediaSessionSeekToDetailsDataView> {
  using Data = ::blink::mojom::internal::MediaSessionSeekToDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SpecMediaMetadataDataView> {
  using Data = ::blink::mojom::internal::SpecMediaMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::MediaSessionActionDetailsDataView> {
  using Data = ::blink::mojom::internal::MediaSessionActionDetails_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class MediaSessionPlaybackState : int32_t {
  
  NONE = 0,
  
  PAUSED = 1,
  
  PLAYING = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, MediaSessionPlaybackState value);
inline bool IsKnownEnumValue(MediaSessionPlaybackState value) {
  return internal::MediaSessionPlaybackState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class MediaSessionClientInterfaceBase {};

using MediaSessionClientPtrDataView =
    mojo::InterfacePtrDataView<MediaSessionClientInterfaceBase>;
using MediaSessionClientRequestDataView =
    mojo::InterfaceRequestDataView<MediaSessionClientInterfaceBase>;
using MediaSessionClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaSessionClientInterfaceBase>;
using MediaSessionClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaSessionClientInterfaceBase>;
class MediaSessionServiceInterfaceBase {};

using MediaSessionServicePtrDataView =
    mojo::InterfacePtrDataView<MediaSessionServiceInterfaceBase>;
using MediaSessionServiceRequestDataView =
    mojo::InterfaceRequestDataView<MediaSessionServiceInterfaceBase>;
using MediaSessionServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaSessionServiceInterfaceBase>;
using MediaSessionServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaSessionServiceInterfaceBase>;


class MediaSessionSeekToDetailsDataView {
 public:
  MediaSessionSeekToDetailsDataView() {}

  MediaSessionSeekToDetailsDataView(
      internal::MediaSessionSeekToDetails_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSeekTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSeekTime(UserType* output) {
    
    auto* pointer = data_->seek_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, context_);
  }
  bool fast_seek() const {
    return data_->fast_seek;
  }
 private:
  internal::MediaSessionSeekToDetails_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class SpecMediaMetadataDataView {
 public:
  SpecMediaMetadataDataView() {}

  SpecMediaMetadataDataView(
      internal::SpecMediaMetadata_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, context_);
  }
  inline void GetArtistDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadArtist(UserType* output) {
    
    auto* pointer = data_->artist.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, context_);
  }
  inline void GetAlbumDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAlbum(UserType* output) {
    
    auto* pointer = data_->album.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, context_);
  }
  inline void GetArtworkDataView(
      mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadArtwork(UserType* output) {
    
    auto* pointer = data_->artwork.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>>(
        pointer, output, context_);
  }
 private:
  internal::SpecMediaMetadata_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MediaSessionActionDetailsDataView {
 public:
  using Tag = internal::MediaSessionActionDetails_Data::MediaSessionActionDetails_Tag;

  MediaSessionActionDetailsDataView() {}

  MediaSessionActionDetailsDataView(
      internal::MediaSessionActionDetails_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_seek_to() const { return data_->tag == Tag::SEEK_TO; }
  inline void GetSeekToDataView(
      MediaSessionSeekToDetailsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSeekTo(UserType* output) {
    
    DCHECK(is_seek_to());
    return mojo::internal::Deserialize<::blink::mojom::MediaSessionSeekToDetailsDataView>(
        data_->data.f_seek_to.Get(), output, context_);
  }

 private:
  internal::MediaSessionActionDetails_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::MediaSessionPlaybackState>
    : public mojo::internal::EnumHashImpl<::blink::mojom::MediaSessionPlaybackState> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::MediaSessionPlaybackState, ::blink::mojom::MediaSessionPlaybackState> {
  static ::blink::mojom::MediaSessionPlaybackState ToMojom(::blink::mojom::MediaSessionPlaybackState input) { return input; }
  static bool FromMojom(::blink::mojom::MediaSessionPlaybackState input, ::blink::mojom::MediaSessionPlaybackState* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaSessionPlaybackState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::MediaSessionPlaybackState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::MediaSessionPlaybackState>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaSessionSeekToDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MediaSessionSeekToDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::MediaSessionSeekToDetails_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::seek_time(input)) in_seek_time = Traits::seek_time(input);
    typename decltype((*output)->seek_time)::BaseType::BufferWriter
        seek_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_seek_time, buffer, &seek_time_writer, context);
    (*output)->seek_time.Set(
        seek_time_writer.is_null() ? nullptr : seek_time_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->seek_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null seek_time in MediaSessionSeekToDetails struct");
    (*output)->fast_seek = Traits::fast_seek(input);
  }

  static bool Deserialize(::blink::mojom::internal::MediaSessionSeekToDetails_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MediaSessionSeekToDetailsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SpecMediaMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SpecMediaMetadataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::SpecMediaMetadata_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::title(input)) in_title = Traits::title(input);
    typename decltype((*output)->title)::BaseType::BufferWriter
        title_writer;
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_title, buffer, &title_writer, context);
    (*output)->title.Set(
        title_writer.is_null() ? nullptr : title_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->title.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in SpecMediaMetadata struct");
    decltype(Traits::artist(input)) in_artist = Traits::artist(input);
    typename decltype((*output)->artist)::BaseType::BufferWriter
        artist_writer;
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_artist, buffer, &artist_writer, context);
    (*output)->artist.Set(
        artist_writer.is_null() ? nullptr : artist_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->artist.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null artist in SpecMediaMetadata struct");
    decltype(Traits::album(input)) in_album = Traits::album(input);
    typename decltype((*output)->album)::BaseType::BufferWriter
        album_writer;
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_album, buffer, &album_writer, context);
    (*output)->album.Set(
        album_writer.is_null() ? nullptr : album_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->album.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null album in SpecMediaMetadata struct");
    decltype(Traits::artwork(input)) in_artwork = Traits::artwork(input);
    typename decltype((*output)->artwork)::BaseType::BufferWriter
        artwork_writer;
    const mojo::internal::ContainerValidateParams artwork_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>>(
        in_artwork, buffer, &artwork_writer, &artwork_validate_params,
        context);
    (*output)->artwork.Set(
        artwork_writer.is_null() ? nullptr : artwork_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->artwork.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null artwork in SpecMediaMetadata struct");
  }

  static bool Deserialize(::blink::mojom::internal::SpecMediaMetadata_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SpecMediaMetadataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaSessionActionDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::MediaSessionActionDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::MediaSessionActionDetails_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::blink::mojom::internal::MediaSessionActionDetails_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::blink::mojom::MediaSessionActionDetailsDataView::Tag::SEEK_TO: {
        decltype(Traits::seek_to(input))
            in_seek_to = Traits::seek_to(input);
        typename decltype(result->data.f_seek_to)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::MediaSessionSeekToDetailsDataView>(
            in_seek_to, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null seek_to in MediaSessionActionDetails union");
        result->data.f_seek_to.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::MediaSessionActionDetails_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MediaSessionActionDetailsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void MediaSessionSeekToDetailsDataView::GetSeekTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->seek_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, context_);
}


inline void SpecMediaMetadataDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, context_);
}
inline void SpecMediaMetadataDataView::GetArtistDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->artist.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, context_);
}
inline void SpecMediaMetadataDataView::GetAlbumDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->album.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, context_);
}
inline void SpecMediaMetadataDataView::GetArtworkDataView(
    mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>* output) {
  auto pointer = data_->artwork.Get();
  *output = mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>(pointer, context_);
}


inline void MediaSessionActionDetailsDataView::GetSeekToDataView(
    MediaSessionSeekToDetailsDataView* output) {
  DCHECK(is_seek_to());
  *output = MediaSessionSeekToDetailsDataView(data_->data.f_seek_to.Get(), context_);
}


}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_SHARED_H_