// third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-shared.h"
#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"




namespace WTF {
struct blink_mojom_internal_V8DetailedMemoryReporter_Mode_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::V8DetailedMemoryReporter_Mode& value) {
    using utype = std::underlying_type<::blink::mojom::V8DetailedMemoryReporter_Mode>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::V8DetailedMemoryReporter_Mode& left, const ::blink::mojom::V8DetailedMemoryReporter_Mode& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::V8DetailedMemoryReporter_Mode>
    : public GenericHashTraits<::blink::mojom::V8DetailedMemoryReporter_Mode> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::V8DetailedMemoryReporter_Mode& value) {
    return value == static_cast<::blink::mojom::V8DetailedMemoryReporter_Mode>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::V8DetailedMemoryReporter_Mode& slot, bool) {
    slot = static_cast<::blink::mojom::V8DetailedMemoryReporter_Mode>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::V8DetailedMemoryReporter_Mode& value) {
    return value == static_cast<::blink::mojom::V8DetailedMemoryReporter_Mode>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class V8DetailedMemoryReporterProxy;

template <typename ImplRefTraits>
class V8DetailedMemoryReporterStub;

class V8DetailedMemoryReporterRequestValidator;
class V8DetailedMemoryReporterResponseValidator;


class PLATFORM_EXPORT V8DetailedMemoryReporter
    : public V8DetailedMemoryReporterInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = V8DetailedMemoryReporterInterfaceBase;
  using Proxy_ = V8DetailedMemoryReporterProxy;

  template <typename ImplRefTraits>
  using Stub_ = V8DetailedMemoryReporterStub<ImplRefTraits>;

  using RequestValidator_ = V8DetailedMemoryReporterRequestValidator;
  using ResponseValidator_ = V8DetailedMemoryReporterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetV8MemoryUsageMinVersion = 0,
  };
  
  using Mode = V8DetailedMemoryReporter_Mode;
  virtual ~V8DetailedMemoryReporter() {}


  using GetV8MemoryUsageCallback = base::OnceCallback<void(PerProcessV8MemoryUsagePtr)>;
  
  virtual void GetV8MemoryUsage(V8DetailedMemoryReporter::Mode mode, GetV8MemoryUsageCallback callback) = 0;
};



class PLATFORM_EXPORT V8DetailedMemoryReporterProxy
    : public V8DetailedMemoryReporter {
 public:
  using InterfaceType = V8DetailedMemoryReporter;

  explicit V8DetailedMemoryReporterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetV8MemoryUsage(V8DetailedMemoryReporter::Mode mode, GetV8MemoryUsageCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT V8DetailedMemoryReporterStubDispatch {
 public:
  static bool Accept(V8DetailedMemoryReporter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      V8DetailedMemoryReporter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<V8DetailedMemoryReporter>>
class V8DetailedMemoryReporterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  V8DetailedMemoryReporterStub() {}
  ~V8DetailedMemoryReporterStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return V8DetailedMemoryReporterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return V8DetailedMemoryReporterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT V8DetailedMemoryReporterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT V8DetailedMemoryReporterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class PLATFORM_EXPORT PerContextV8MemoryUsage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PerContextV8MemoryUsage, T>::value>;
  using DataView = PerContextV8MemoryUsageDataView;
  using Data_ = internal::PerContextV8MemoryUsage_Data;

  template <typename... Args>
  static PerContextV8MemoryUsagePtr New(Args&&... args) {
    return PerContextV8MemoryUsagePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PerContextV8MemoryUsagePtr From(const U& u) {
    return mojo::TypeConverter<PerContextV8MemoryUsagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PerContextV8MemoryUsage>::Convert(*this);
  }


  PerContextV8MemoryUsage();

  PerContextV8MemoryUsage(
      const ::blink::ExecutionContextToken& token,
      uint64_t bytes_used);

  ~PerContextV8MemoryUsage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PerContextV8MemoryUsagePtr>
  PerContextV8MemoryUsagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PerContextV8MemoryUsage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PerContextV8MemoryUsage::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PerContextV8MemoryUsage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PerContextV8MemoryUsage_UnserializedMessageContext<
            UserType, PerContextV8MemoryUsage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PerContextV8MemoryUsage::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PerContextV8MemoryUsage::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PerContextV8MemoryUsage_UnserializedMessageContext<
            UserType, PerContextV8MemoryUsage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PerContextV8MemoryUsage::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::ExecutionContextToken token;
  
  uint64_t bytes_used;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PerContextV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PerContextV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PerContextV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PerContextV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT PerIsolateV8MemoryUsage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PerIsolateV8MemoryUsage, T>::value>;
  using DataView = PerIsolateV8MemoryUsageDataView;
  using Data_ = internal::PerIsolateV8MemoryUsage_Data;

  template <typename... Args>
  static PerIsolateV8MemoryUsagePtr New(Args&&... args) {
    return PerIsolateV8MemoryUsagePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PerIsolateV8MemoryUsagePtr From(const U& u) {
    return mojo::TypeConverter<PerIsolateV8MemoryUsagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PerIsolateV8MemoryUsage>::Convert(*this);
  }


  PerIsolateV8MemoryUsage();

  PerIsolateV8MemoryUsage(
      uint64_t unassociated_bytes_used,
      uint64_t num_unassociated_contexts,
      uint64_t unassociated_context_bytes_used,
      WTF::Vector<PerContextV8MemoryUsagePtr> contexts);

  ~PerIsolateV8MemoryUsage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PerIsolateV8MemoryUsagePtr>
  PerIsolateV8MemoryUsagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PerIsolateV8MemoryUsage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PerIsolateV8MemoryUsage::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PerIsolateV8MemoryUsage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PerIsolateV8MemoryUsage_UnserializedMessageContext<
            UserType, PerIsolateV8MemoryUsage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PerIsolateV8MemoryUsage::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PerIsolateV8MemoryUsage::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PerIsolateV8MemoryUsage_UnserializedMessageContext<
            UserType, PerIsolateV8MemoryUsage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PerIsolateV8MemoryUsage::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint64_t unassociated_bytes_used;
  
  uint64_t num_unassociated_contexts;
  
  uint64_t unassociated_context_bytes_used;
  
  WTF::Vector<PerContextV8MemoryUsagePtr> contexts;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(PerIsolateV8MemoryUsage);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PerIsolateV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PerIsolateV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PerIsolateV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PerIsolateV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT PerProcessV8MemoryUsage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PerProcessV8MemoryUsage, T>::value>;
  using DataView = PerProcessV8MemoryUsageDataView;
  using Data_ = internal::PerProcessV8MemoryUsage_Data;

  template <typename... Args>
  static PerProcessV8MemoryUsagePtr New(Args&&... args) {
    return PerProcessV8MemoryUsagePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PerProcessV8MemoryUsagePtr From(const U& u) {
    return mojo::TypeConverter<PerProcessV8MemoryUsagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PerProcessV8MemoryUsage>::Convert(*this);
  }


  PerProcessV8MemoryUsage();

  explicit PerProcessV8MemoryUsage(
      WTF::Vector<PerIsolateV8MemoryUsagePtr> isolates);

  ~PerProcessV8MemoryUsage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PerProcessV8MemoryUsagePtr>
  PerProcessV8MemoryUsagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PerProcessV8MemoryUsage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PerProcessV8MemoryUsage::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PerProcessV8MemoryUsage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PerProcessV8MemoryUsage_UnserializedMessageContext<
            UserType, PerProcessV8MemoryUsage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PerProcessV8MemoryUsage::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PerProcessV8MemoryUsage::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PerProcessV8MemoryUsage_UnserializedMessageContext<
            UserType, PerProcessV8MemoryUsage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PerProcessV8MemoryUsage::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::Vector<PerIsolateV8MemoryUsagePtr> isolates;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(PerProcessV8MemoryUsage);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PerProcessV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PerProcessV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PerProcessV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PerProcessV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PerContextV8MemoryUsagePtr PerContextV8MemoryUsage::Clone() const {
  return New(
      mojo::Clone(token),
      mojo::Clone(bytes_used)
  );
}

template <typename T, PerContextV8MemoryUsage::EnableIfSame<T>*>
bool PerContextV8MemoryUsage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  if (!mojo::Equals(this->bytes_used, other_struct.bytes_used))
    return false;
  return true;
}

template <typename T, PerContextV8MemoryUsage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.token, rhs.token))
    return true;
  if (std::less<>{}(rhs.token, lhs.token))
    return false;
  if (std::less<>{}(lhs.bytes_used, rhs.bytes_used))
    return true;
  if (std::less<>{}(rhs.bytes_used, lhs.bytes_used))
    return false;
  return false;
}
template <typename StructPtrType>
PerIsolateV8MemoryUsagePtr PerIsolateV8MemoryUsage::Clone() const {
  return New(
      mojo::Clone(unassociated_bytes_used),
      mojo::Clone(num_unassociated_contexts),
      mojo::Clone(unassociated_context_bytes_used),
      mojo::Clone(contexts)
  );
}

template <typename T, PerIsolateV8MemoryUsage::EnableIfSame<T>*>
bool PerIsolateV8MemoryUsage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->unassociated_bytes_used, other_struct.unassociated_bytes_used))
    return false;
  if (!mojo::Equals(this->num_unassociated_contexts, other_struct.num_unassociated_contexts))
    return false;
  if (!mojo::Equals(this->unassociated_context_bytes_used, other_struct.unassociated_context_bytes_used))
    return false;
  if (!mojo::Equals(this->contexts, other_struct.contexts))
    return false;
  return true;
}

template <typename T, PerIsolateV8MemoryUsage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.unassociated_bytes_used, rhs.unassociated_bytes_used))
    return true;
  if (std::less<>{}(rhs.unassociated_bytes_used, lhs.unassociated_bytes_used))
    return false;
  if (std::less<>{}(lhs.num_unassociated_contexts, rhs.num_unassociated_contexts))
    return true;
  if (std::less<>{}(rhs.num_unassociated_contexts, lhs.num_unassociated_contexts))
    return false;
  if (std::less<>{}(lhs.unassociated_context_bytes_used, rhs.unassociated_context_bytes_used))
    return true;
  if (std::less<>{}(rhs.unassociated_context_bytes_used, lhs.unassociated_context_bytes_used))
    return false;
  if (std::less<>{}(lhs.contexts, rhs.contexts))
    return true;
  if (std::less<>{}(rhs.contexts, lhs.contexts))
    return false;
  return false;
}
template <typename StructPtrType>
PerProcessV8MemoryUsagePtr PerProcessV8MemoryUsage::Clone() const {
  return New(
      mojo::Clone(isolates)
  );
}

template <typename T, PerProcessV8MemoryUsage::EnableIfSame<T>*>
bool PerProcessV8MemoryUsage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->isolates, other_struct.isolates))
    return false;
  return true;
}

template <typename T, PerProcessV8MemoryUsage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.isolates, rhs.isolates))
    return true;
  if (std::less<>{}(rhs.isolates, lhs.isolates))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PerContextV8MemoryUsage::DataView,
                                         ::blink::mojom::blink::PerContextV8MemoryUsagePtr> {
  static bool IsNull(const ::blink::mojom::blink::PerContextV8MemoryUsagePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PerContextV8MemoryUsagePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::PerContextV8MemoryUsage::token)& token(
      const ::blink::mojom::blink::PerContextV8MemoryUsagePtr& input) {
    return input->token;
  }

  static decltype(::blink::mojom::blink::PerContextV8MemoryUsage::bytes_used) bytes_used(
      const ::blink::mojom::blink::PerContextV8MemoryUsagePtr& input) {
    return input->bytes_used;
  }

  static bool Read(::blink::mojom::blink::PerContextV8MemoryUsage::DataView input, ::blink::mojom::blink::PerContextV8MemoryUsagePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PerIsolateV8MemoryUsage::DataView,
                                         ::blink::mojom::blink::PerIsolateV8MemoryUsagePtr> {
  static bool IsNull(const ::blink::mojom::blink::PerIsolateV8MemoryUsagePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PerIsolateV8MemoryUsagePtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::PerIsolateV8MemoryUsage::unassociated_bytes_used) unassociated_bytes_used(
      const ::blink::mojom::blink::PerIsolateV8MemoryUsagePtr& input) {
    return input->unassociated_bytes_used;
  }

  static decltype(::blink::mojom::blink::PerIsolateV8MemoryUsage::num_unassociated_contexts) num_unassociated_contexts(
      const ::blink::mojom::blink::PerIsolateV8MemoryUsagePtr& input) {
    return input->num_unassociated_contexts;
  }

  static decltype(::blink::mojom::blink::PerIsolateV8MemoryUsage::unassociated_context_bytes_used) unassociated_context_bytes_used(
      const ::blink::mojom::blink::PerIsolateV8MemoryUsagePtr& input) {
    return input->unassociated_context_bytes_used;
  }

  static const decltype(::blink::mojom::blink::PerIsolateV8MemoryUsage::contexts)& contexts(
      const ::blink::mojom::blink::PerIsolateV8MemoryUsagePtr& input) {
    return input->contexts;
  }

  static bool Read(::blink::mojom::blink::PerIsolateV8MemoryUsage::DataView input, ::blink::mojom::blink::PerIsolateV8MemoryUsagePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PerProcessV8MemoryUsage::DataView,
                                         ::blink::mojom::blink::PerProcessV8MemoryUsagePtr> {
  static bool IsNull(const ::blink::mojom::blink::PerProcessV8MemoryUsagePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PerProcessV8MemoryUsagePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::PerProcessV8MemoryUsage::isolates)& isolates(
      const ::blink::mojom::blink::PerProcessV8MemoryUsagePtr& input) {
    return input->isolates;
  }

  static bool Read(::blink::mojom::blink::PerProcessV8MemoryUsage::DataView input, ::blink::mojom::blink::PerProcessV8MemoryUsagePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_BLINK_H_