// third_party/blink/public/mojom/screen_enumeration/screen_enumeration.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCREEN_ENUMERATION_SCREEN_ENUMERATION_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCREEN_ENUMERATION_SCREEN_ENUMERATION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/screen_enumeration/screen_enumeration.mojom-shared-internal.h"
#include "ui/display/mojom/display.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class DisplaysDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::DisplaysDataView> {
  using Data = ::blink::mojom::internal::Displays_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class MultipleDisplays : int32_t {
  
  kFalse = 0,
  
  kTrue = 1,
  
  kError = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, MultipleDisplays value);
inline bool IsKnownEnumValue(MultipleDisplays value) {
  return internal::MultipleDisplays_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ScreenEnumerationInterfaceBase {};

using ScreenEnumerationPtrDataView =
    mojo::InterfacePtrDataView<ScreenEnumerationInterfaceBase>;
using ScreenEnumerationRequestDataView =
    mojo::InterfaceRequestDataView<ScreenEnumerationInterfaceBase>;
using ScreenEnumerationAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ScreenEnumerationInterfaceBase>;
using ScreenEnumerationAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ScreenEnumerationInterfaceBase>;


class DisplaysDataView {
 public:
  DisplaysDataView() {}

  DisplaysDataView(
      internal::Displays_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDisplaysDataView(
      mojo::ArrayDataView<::display::mojom::DisplayDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDisplays(UserType* output) {
    
    auto* pointer = data_->displays.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::display::mojom::DisplayDataView>>(
        pointer, output, context_);
  }
  int64_t internal_id() const {
    return data_->internal_id;
  }
  int64_t primary_id() const {
    return data_->primary_id;
  }
 private:
  internal::Displays_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::MultipleDisplays>
    : public mojo::internal::EnumHashImpl<::blink::mojom::MultipleDisplays> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::MultipleDisplays, ::blink::mojom::MultipleDisplays> {
  static ::blink::mojom::MultipleDisplays ToMojom(::blink::mojom::MultipleDisplays input) { return input; }
  static bool FromMojom(::blink::mojom::MultipleDisplays input, ::blink::mojom::MultipleDisplays* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MultipleDisplays, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::MultipleDisplays, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::MultipleDisplays>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DisplaysDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DisplaysDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::Displays_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::displays(input)) in_displays = Traits::displays(input);
    typename decltype((*output)->displays)::BaseType::BufferWriter
        displays_writer;
    const mojo::internal::ContainerValidateParams displays_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::display::mojom::DisplayDataView>>(
        in_displays, buffer, &displays_writer, &displays_validate_params,
        context);
    (*output)->displays.Set(
        displays_writer.is_null() ? nullptr : displays_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->displays.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null displays in Displays struct");
    (*output)->internal_id = Traits::internal_id(input);
    (*output)->primary_id = Traits::primary_id(input);
  }

  static bool Deserialize(::blink::mojom::internal::Displays_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DisplaysDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void DisplaysDataView::GetDisplaysDataView(
    mojo::ArrayDataView<::display::mojom::DisplayDataView>* output) {
  auto pointer = data_->displays.Get();
  *output = mojo::ArrayDataView<::display::mojom::DisplayDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCREEN_ENUMERATION_SCREEN_ENUMERATION_MOJOM_SHARED_H_