// third_party/blink/public/mojom/webauthn/virtual_authenticator.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_VIRTUAL_AUTHENTICATOR_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_VIRTUAL_AUTHENTICATOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/webauthn/virtual_authenticator.mojom-shared.h"
#include "third_party/blink/public/mojom/webauthn/virtual_authenticator.mojom-forward.h"
#include "url/mojom/url.mojom-forward.h"
#include "third_party/blink/public/mojom/webauthn/authenticator.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "content/browser/webauth/virtual_authenticator_mojom_traits.h"
#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace test {
namespace mojom {

class VirtualAuthenticatorProxy;

template <typename ImplRefTraits>
class VirtualAuthenticatorStub;

class VirtualAuthenticatorRequestValidator;
class VirtualAuthenticatorResponseValidator;


class BLINK_COMMON_EXPORT VirtualAuthenticator
    : public VirtualAuthenticatorInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = VirtualAuthenticatorInterfaceBase;
  using Proxy_ = VirtualAuthenticatorProxy;

  template <typename ImplRefTraits>
  using Stub_ = VirtualAuthenticatorStub<ImplRefTraits>;

  using RequestValidator_ = VirtualAuthenticatorRequestValidator;
  using ResponseValidator_ = VirtualAuthenticatorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetUniqueIdMinVersion = 0,
    kAddRegistrationMinVersion = 0,
    kGetRegistrationsMinVersion = 0,
    kRemoveRegistrationMinVersion = 0,
    kClearRegistrationsMinVersion = 0,
    kSetUserVerifiedMinVersion = 0,
  };
  virtual ~VirtualAuthenticator() {}


  using GetUniqueIdCallback = base::OnceCallback<void(const std::string&)>;
  
  virtual void GetUniqueId(GetUniqueIdCallback callback) = 0;


  using AddRegistrationCallback = base::OnceCallback<void(bool)>;
  
  virtual void AddRegistration(RegisteredKeyPtr key, AddRegistrationCallback callback) = 0;


  using GetRegistrationsCallback = base::OnceCallback<void(std::vector<RegisteredKeyPtr>)>;
  
  virtual void GetRegistrations(GetRegistrationsCallback callback) = 0;


  using RemoveRegistrationCallback = base::OnceCallback<void(bool)>;
  
  virtual void RemoveRegistration(const std::vector<uint8_t>& key_handle, RemoveRegistrationCallback callback) = 0;


  using ClearRegistrationsCallback = base::OnceCallback<void()>;
  
  virtual void ClearRegistrations(ClearRegistrationsCallback callback) = 0;


  using SetUserVerifiedCallback = base::OnceCallback<void()>;
  
  virtual void SetUserVerified(bool verified, SetUserVerifiedCallback callback) = 0;
};

class VirtualAuthenticatorManagerProxy;

template <typename ImplRefTraits>
class VirtualAuthenticatorManagerStub;

class VirtualAuthenticatorManagerRequestValidator;
class VirtualAuthenticatorManagerResponseValidator;


class BLINK_COMMON_EXPORT VirtualAuthenticatorManager
    : public VirtualAuthenticatorManagerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = VirtualAuthenticatorManagerInterfaceBase;
  using Proxy_ = VirtualAuthenticatorManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = VirtualAuthenticatorManagerStub<ImplRefTraits>;

  using RequestValidator_ = VirtualAuthenticatorManagerRequestValidator;
  using ResponseValidator_ = VirtualAuthenticatorManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateAuthenticatorMinVersion = 0,
    kGetAuthenticatorsMinVersion = 0,
    kRemoveAuthenticatorMinVersion = 0,
    kClearAuthenticatorsMinVersion = 0,
  };
  virtual ~VirtualAuthenticatorManager() {}


  using CreateAuthenticatorCallback = base::OnceCallback<void(::mojo::PendingRemote<VirtualAuthenticator>)>;
  
  virtual void CreateAuthenticator(VirtualAuthenticatorOptionsPtr options, CreateAuthenticatorCallback callback) = 0;


  using GetAuthenticatorsCallback = base::OnceCallback<void(std::vector<::mojo::PendingRemote<VirtualAuthenticator>>)>;
  
  virtual void GetAuthenticators(GetAuthenticatorsCallback callback) = 0;


  using RemoveAuthenticatorCallback = base::OnceCallback<void(bool)>;
  
  virtual void RemoveAuthenticator(const std::string& id, RemoveAuthenticatorCallback callback) = 0;


  using ClearAuthenticatorsCallback = base::OnceCallback<void()>;
  
  virtual void ClearAuthenticators(ClearAuthenticatorsCallback callback) = 0;
};



class BLINK_COMMON_EXPORT VirtualAuthenticatorProxy
    : public VirtualAuthenticator {
 public:
  using InterfaceType = VirtualAuthenticator;

  explicit VirtualAuthenticatorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetUniqueId(GetUniqueIdCallback callback) final;
  
  void AddRegistration(RegisteredKeyPtr key, AddRegistrationCallback callback) final;
  
  void GetRegistrations(GetRegistrationsCallback callback) final;
  
  void RemoveRegistration(const std::vector<uint8_t>& key_handle, RemoveRegistrationCallback callback) final;
  
  void ClearRegistrations(ClearRegistrationsCallback callback) final;
  
  void SetUserVerified(bool verified, SetUserVerifiedCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT VirtualAuthenticatorManagerProxy
    : public VirtualAuthenticatorManager {
 public:
  using InterfaceType = VirtualAuthenticatorManager;

  explicit VirtualAuthenticatorManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateAuthenticator(VirtualAuthenticatorOptionsPtr options, CreateAuthenticatorCallback callback) final;
  
  void GetAuthenticators(GetAuthenticatorsCallback callback) final;
  
  void RemoveAuthenticator(const std::string& id, RemoveAuthenticatorCallback callback) final;
  
  void ClearAuthenticators(ClearAuthenticatorsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT VirtualAuthenticatorStubDispatch {
 public:
  static bool Accept(VirtualAuthenticator* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VirtualAuthenticator* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VirtualAuthenticator>>
class VirtualAuthenticatorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VirtualAuthenticatorStub() {}
  ~VirtualAuthenticatorStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VirtualAuthenticatorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VirtualAuthenticatorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT VirtualAuthenticatorManagerStubDispatch {
 public:
  static bool Accept(VirtualAuthenticatorManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VirtualAuthenticatorManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VirtualAuthenticatorManager>>
class VirtualAuthenticatorManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VirtualAuthenticatorManagerStub() {}
  ~VirtualAuthenticatorManagerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VirtualAuthenticatorManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VirtualAuthenticatorManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT VirtualAuthenticatorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT VirtualAuthenticatorManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT VirtualAuthenticatorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT VirtualAuthenticatorManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class BLINK_COMMON_EXPORT VirtualAuthenticatorOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VirtualAuthenticatorOptions, T>::value>;
  using DataView = VirtualAuthenticatorOptionsDataView;
  using Data_ = internal::VirtualAuthenticatorOptions_Data;

  template <typename... Args>
  static VirtualAuthenticatorOptionsPtr New(Args&&... args) {
    return VirtualAuthenticatorOptionsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VirtualAuthenticatorOptionsPtr From(const U& u) {
    return mojo::TypeConverter<VirtualAuthenticatorOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VirtualAuthenticatorOptions>::Convert(*this);
  }


  VirtualAuthenticatorOptions();

  VirtualAuthenticatorOptions(
      ::device::ProtocolVersion protocol,
      ::device::Ctap2Version ctap2_version,
      ::device::FidoTransportProtocol transport,
      ::device::AuthenticatorAttachment attachment,
      bool has_resident_key,
      bool has_user_verification,
      bool is_user_present);

  ~VirtualAuthenticatorOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VirtualAuthenticatorOptionsPtr>
  VirtualAuthenticatorOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VirtualAuthenticatorOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VirtualAuthenticatorOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VirtualAuthenticatorOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VirtualAuthenticatorOptions_UnserializedMessageContext<
            UserType, VirtualAuthenticatorOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VirtualAuthenticatorOptions::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return VirtualAuthenticatorOptions::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VirtualAuthenticatorOptions_UnserializedMessageContext<
            UserType, VirtualAuthenticatorOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VirtualAuthenticatorOptions::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::device::ProtocolVersion protocol;
  
  ::device::Ctap2Version ctap2_version;
  
  ::device::FidoTransportProtocol transport;
  
  ::device::AuthenticatorAttachment attachment;
  
  bool has_resident_key;
  
  bool has_user_verification;
  
  bool is_user_present;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VirtualAuthenticatorOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VirtualAuthenticatorOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VirtualAuthenticatorOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VirtualAuthenticatorOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT RegisteredKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RegisteredKey, T>::value>;
  using DataView = RegisteredKeyDataView;
  using Data_ = internal::RegisteredKey_Data;

  template <typename... Args>
  static RegisteredKeyPtr New(Args&&... args) {
    return RegisteredKeyPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RegisteredKeyPtr From(const U& u) {
    return mojo::TypeConverter<RegisteredKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RegisteredKey>::Convert(*this);
  }


  RegisteredKey();

  RegisteredKey(
      std::vector<uint8_t> key_handle,
      const std::string& rp_id,
      std::vector<uint8_t> private_key,
      int32_t counter);

  ~RegisteredKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RegisteredKeyPtr>
  RegisteredKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RegisteredKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RegisteredKey::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RegisteredKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RegisteredKey_UnserializedMessageContext<
            UserType, RegisteredKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<RegisteredKey::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return RegisteredKey::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RegisteredKey_UnserializedMessageContext<
            UserType, RegisteredKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RegisteredKey::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<uint8_t> key_handle;
  
  std::string rp_id;
  
  std::vector<uint8_t> private_key;
  
  int32_t counter;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RegisteredKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RegisteredKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RegisteredKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RegisteredKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
VirtualAuthenticatorOptionsPtr VirtualAuthenticatorOptions::Clone() const {
  return New(
      mojo::Clone(protocol),
      mojo::Clone(ctap2_version),
      mojo::Clone(transport),
      mojo::Clone(attachment),
      mojo::Clone(has_resident_key),
      mojo::Clone(has_user_verification),
      mojo::Clone(is_user_present)
  );
}

template <typename T, VirtualAuthenticatorOptions::EnableIfSame<T>*>
bool VirtualAuthenticatorOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->protocol, other_struct.protocol))
    return false;
  if (!mojo::Equals(this->ctap2_version, other_struct.ctap2_version))
    return false;
  if (!mojo::Equals(this->transport, other_struct.transport))
    return false;
  if (!mojo::Equals(this->attachment, other_struct.attachment))
    return false;
  if (!mojo::Equals(this->has_resident_key, other_struct.has_resident_key))
    return false;
  if (!mojo::Equals(this->has_user_verification, other_struct.has_user_verification))
    return false;
  if (!mojo::Equals(this->is_user_present, other_struct.is_user_present))
    return false;
  return true;
}

template <typename T, VirtualAuthenticatorOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.protocol, rhs.protocol))
    return true;
  if (std::less<>{}(rhs.protocol, lhs.protocol))
    return false;
  if (std::less<>{}(lhs.ctap2_version, rhs.ctap2_version))
    return true;
  if (std::less<>{}(rhs.ctap2_version, lhs.ctap2_version))
    return false;
  if (std::less<>{}(lhs.transport, rhs.transport))
    return true;
  if (std::less<>{}(rhs.transport, lhs.transport))
    return false;
  if (std::less<>{}(lhs.attachment, rhs.attachment))
    return true;
  if (std::less<>{}(rhs.attachment, lhs.attachment))
    return false;
  if (std::less<>{}(lhs.has_resident_key, rhs.has_resident_key))
    return true;
  if (std::less<>{}(rhs.has_resident_key, lhs.has_resident_key))
    return false;
  if (std::less<>{}(lhs.has_user_verification, rhs.has_user_verification))
    return true;
  if (std::less<>{}(rhs.has_user_verification, lhs.has_user_verification))
    return false;
  if (std::less<>{}(lhs.is_user_present, rhs.is_user_present))
    return true;
  if (std::less<>{}(rhs.is_user_present, lhs.is_user_present))
    return false;
  return false;
}
template <typename StructPtrType>
RegisteredKeyPtr RegisteredKey::Clone() const {
  return New(
      mojo::Clone(key_handle),
      mojo::Clone(rp_id),
      mojo::Clone(private_key),
      mojo::Clone(counter)
  );
}

template <typename T, RegisteredKey::EnableIfSame<T>*>
bool RegisteredKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key_handle, other_struct.key_handle))
    return false;
  if (!mojo::Equals(this->rp_id, other_struct.rp_id))
    return false;
  if (!mojo::Equals(this->private_key, other_struct.private_key))
    return false;
  if (!mojo::Equals(this->counter, other_struct.counter))
    return false;
  return true;
}

template <typename T, RegisteredKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.key_handle, rhs.key_handle))
    return true;
  if (std::less<>{}(rhs.key_handle, lhs.key_handle))
    return false;
  if (std::less<>{}(lhs.rp_id, rhs.rp_id))
    return true;
  if (std::less<>{}(rhs.rp_id, lhs.rp_id))
    return false;
  if (std::less<>{}(lhs.private_key, rhs.private_key))
    return true;
  if (std::less<>{}(rhs.private_key, lhs.private_key))
    return false;
  if (std::less<>{}(lhs.counter, rhs.counter))
    return true;
  if (std::less<>{}(rhs.counter, lhs.counter))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace test
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::test::mojom::VirtualAuthenticatorOptions::DataView,
                                         ::blink::test::mojom::VirtualAuthenticatorOptionsPtr> {
  static bool IsNull(const ::blink::test::mojom::VirtualAuthenticatorOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::test::mojom::VirtualAuthenticatorOptionsPtr* output) { output->reset(); }

  static decltype(::blink::test::mojom::VirtualAuthenticatorOptions::protocol) protocol(
      const ::blink::test::mojom::VirtualAuthenticatorOptionsPtr& input) {
    return input->protocol;
  }

  static decltype(::blink::test::mojom::VirtualAuthenticatorOptions::ctap2_version) ctap2_version(
      const ::blink::test::mojom::VirtualAuthenticatorOptionsPtr& input) {
    return input->ctap2_version;
  }

  static decltype(::blink::test::mojom::VirtualAuthenticatorOptions::transport) transport(
      const ::blink::test::mojom::VirtualAuthenticatorOptionsPtr& input) {
    return input->transport;
  }

  static decltype(::blink::test::mojom::VirtualAuthenticatorOptions::attachment) attachment(
      const ::blink::test::mojom::VirtualAuthenticatorOptionsPtr& input) {
    return input->attachment;
  }

  static decltype(::blink::test::mojom::VirtualAuthenticatorOptions::has_resident_key) has_resident_key(
      const ::blink::test::mojom::VirtualAuthenticatorOptionsPtr& input) {
    return input->has_resident_key;
  }

  static decltype(::blink::test::mojom::VirtualAuthenticatorOptions::has_user_verification) has_user_verification(
      const ::blink::test::mojom::VirtualAuthenticatorOptionsPtr& input) {
    return input->has_user_verification;
  }

  static decltype(::blink::test::mojom::VirtualAuthenticatorOptions::is_user_present) is_user_present(
      const ::blink::test::mojom::VirtualAuthenticatorOptionsPtr& input) {
    return input->is_user_present;
  }

  static bool Read(::blink::test::mojom::VirtualAuthenticatorOptions::DataView input, ::blink::test::mojom::VirtualAuthenticatorOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::test::mojom::RegisteredKey::DataView,
                                         ::blink::test::mojom::RegisteredKeyPtr> {
  static bool IsNull(const ::blink::test::mojom::RegisteredKeyPtr& input) { return !input; }
  static void SetToNull(::blink::test::mojom::RegisteredKeyPtr* output) { output->reset(); }

  static const decltype(::blink::test::mojom::RegisteredKey::key_handle)& key_handle(
      const ::blink::test::mojom::RegisteredKeyPtr& input) {
    return input->key_handle;
  }

  static const decltype(::blink::test::mojom::RegisteredKey::rp_id)& rp_id(
      const ::blink::test::mojom::RegisteredKeyPtr& input) {
    return input->rp_id;
  }

  static const decltype(::blink::test::mojom::RegisteredKey::private_key)& private_key(
      const ::blink::test::mojom::RegisteredKeyPtr& input) {
    return input->private_key;
  }

  static decltype(::blink::test::mojom::RegisteredKey::counter) counter(
      const ::blink::test::mojom::RegisteredKeyPtr& input) {
    return input->counter;
  }

  static bool Read(::blink::test::mojom::RegisteredKey::DataView input, ::blink::test::mojom::RegisteredKeyPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_VIRTUAL_AUTHENTICATOR_MOJOM_H_