// third_party/blink/public/mojom/webtransport/quic_transport_connector.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBTRANSPORT_QUIC_TRANSPORT_CONNECTOR_MOJOM_PARAMS_DATA_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBTRANSPORT_QUIC_TRANSPORT_CONNECTOR_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace blink {
namespace mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) QuicTransportConnector_Connect_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(QuicTransportConnector_Connect_Params_Data));
      new (data()) QuicTransportConnector_Connect_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    QuicTransportConnector_Connect_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<QuicTransportConnector_Connect_Params_Data>(index_);
    }
    QuicTransportConnector_Connect_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::QuicTransportCertificateFingerprint_Data>>> fingerprints;
  mojo::internal::Interface_Data client;

 private:
  QuicTransportConnector_Connect_Params_Data();
  ~QuicTransportConnector_Connect_Params_Data() = delete;
};
static_assert(sizeof(QuicTransportConnector_Connect_Params_Data) == 32,
              "Bad sizeof(QuicTransportConnector_Connect_Params_Data)");

}  // namespace internal


class QuicTransportConnector_Connect_ParamsDataView {
 public:
  QuicTransportConnector_Connect_ParamsDataView() {}

  QuicTransportConnector_Connect_ParamsDataView(
      internal::QuicTransportConnector_Connect_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetFingerprintsDataView(
      mojo::ArrayDataView<::network::mojom::QuicTransportCertificateFingerprintDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFingerprints(UserType* output) {
    
    auto* pointer = data_->fingerprints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::QuicTransportCertificateFingerprintDataView>>(
        pointer, output, context_);
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::QuicTransportHandshakeClientInterfaceBase>>(
            &data_->client, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::QuicTransportConnector_Connect_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void QuicTransportConnector_Connect_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void QuicTransportConnector_Connect_ParamsDataView::GetFingerprintsDataView(
    mojo::ArrayDataView<::network::mojom::QuicTransportCertificateFingerprintDataView>* output) {
  auto pointer = data_->fingerprints.Get();
  *output = mojo::ArrayDataView<::network::mojom::QuicTransportCertificateFingerprintDataView>(pointer, context_);
}

}  // namespace mojom
}  // namespace blink

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBTRANSPORT_QUIC_TRANSPORT_CONNECTOR_MOJOM_PARAMS_DATA_H_