// third_party/blink/public/mojom/widget/visual_properties.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom-shared-internal.h"
#include "cc/mojom/browser_controls_params.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/display_mode.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/screen_info.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"



#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "base/component_export.h"




namespace blink {
namespace mojom {
class VisualPropertiesDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::VisualPropertiesDataView> {
  using Data = ::blink::mojom::internal::VisualProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


class VisualPropertiesDataView {
 public:
  VisualPropertiesDataView() {}

  VisualPropertiesDataView(
      internal::VisualProperties_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetScreenInfoDataView(
      ::blink::mojom::ScreenInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScreenInfo(UserType* output) {
    
    auto* pointer = data_->screen_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::ScreenInfoDataView>(
        pointer, output, context_);
  }
  bool auto_resize_enabled() const {
    return data_->auto_resize_enabled;
  }
  inline void GetMinSizeForAutoResizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMinSizeForAutoResize(UserType* output) {
    
    auto* pointer = data_->min_size_for_auto_resize.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  inline void GetMaxSizeForAutoResizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMaxSizeForAutoResize(UserType* output) {
    
    auto* pointer = data_->max_size_for_auto_resize.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  inline void GetNewSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNewSize(UserType* output) {
    
    auto* pointer = data_->new_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  inline void GetVisibleViewportSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVisibleViewportSize(UserType* output) {
    
    auto* pointer = data_->visible_viewport_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  inline void GetCompositorViewportPixelRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCompositorViewportPixelRect(UserType* output) {
    
    auto* pointer = data_->compositor_viewport_pixel_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, context_);
  }
  inline void GetBrowserControlsParamsDataView(
      ::cc::mojom::BrowserControlsParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBrowserControlsParams(UserType* output) {
    
    auto* pointer = data_->browser_controls_params.Get();
    return mojo::internal::Deserialize<::cc::mojom::BrowserControlsParamsDataView>(
        pointer, output, context_);
  }
  bool scroll_focused_node_into_view() const {
    return data_->scroll_focused_node_into_view;
  }
  inline void GetLocalSurfaceIdDataView(
      ::viz::mojom::LocalSurfaceIdDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLocalSurfaceId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::LocalSurfaceIdDataView, UserType>(),
    "Attempting to read the optional `local_surface_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLocalSurfaceId` instead "
    "of `ReadLocalSurfaceId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->local_surface_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::LocalSurfaceIdDataView>(
        pointer, output, context_);
  }
  bool is_fullscreen_granted() const {
    return data_->is_fullscreen_granted;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDisplayMode(UserType* output) const {
    auto data_value = data_->display_mode;
    return mojo::internal::Deserialize<::blink::mojom::DisplayMode>(
        data_value, output);
  }

  ::blink::mojom::DisplayMode display_mode() const {
    return static_cast<::blink::mojom::DisplayMode>(data_->display_mode);
  }
  uint32_t capture_sequence_number() const {
    return data_->capture_sequence_number;
  }
  double zoom_level() const {
    return data_->zoom_level;
  }
  float page_scale_factor() const {
    return data_->page_scale_factor;
  }
  inline void GetRootWidgetWindowSegmentsDataView(
      mojo::ArrayDataView<::gfx::mojom::RectDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRootWidgetWindowSegments(UserType* output) {
    
    auto* pointer = data_->root_widget_window_segments.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
        pointer, output, context_);
  }
  bool is_pinch_gesture_active() const {
    return data_->is_pinch_gesture_active;
  }
 private:
  internal::VisualProperties_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::VisualPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::VisualPropertiesDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::VisualProperties_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::screen_info(input)) in_screen_info = Traits::screen_info(input);
    typename decltype((*output)->screen_info)::BaseType::BufferWriter
        screen_info_writer;
    mojo::internal::Serialize<::blink::mojom::ScreenInfoDataView>(
        in_screen_info, buffer, &screen_info_writer, context);
    (*output)->screen_info.Set(
        screen_info_writer.is_null() ? nullptr : screen_info_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->screen_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null screen_info in VisualProperties struct");
    (*output)->auto_resize_enabled = Traits::auto_resize_enabled(input);
    decltype(Traits::min_size_for_auto_resize(input)) in_min_size_for_auto_resize = Traits::min_size_for_auto_resize(input);
    typename decltype((*output)->min_size_for_auto_resize)::BaseType::BufferWriter
        min_size_for_auto_resize_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_min_size_for_auto_resize, buffer, &min_size_for_auto_resize_writer, context);
    (*output)->min_size_for_auto_resize.Set(
        min_size_for_auto_resize_writer.is_null() ? nullptr : min_size_for_auto_resize_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->min_size_for_auto_resize.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null min_size_for_auto_resize in VisualProperties struct");
    decltype(Traits::max_size_for_auto_resize(input)) in_max_size_for_auto_resize = Traits::max_size_for_auto_resize(input);
    typename decltype((*output)->max_size_for_auto_resize)::BaseType::BufferWriter
        max_size_for_auto_resize_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_max_size_for_auto_resize, buffer, &max_size_for_auto_resize_writer, context);
    (*output)->max_size_for_auto_resize.Set(
        max_size_for_auto_resize_writer.is_null() ? nullptr : max_size_for_auto_resize_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->max_size_for_auto_resize.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null max_size_for_auto_resize in VisualProperties struct");
    decltype(Traits::new_size(input)) in_new_size = Traits::new_size(input);
    typename decltype((*output)->new_size)::BaseType::BufferWriter
        new_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_new_size, buffer, &new_size_writer, context);
    (*output)->new_size.Set(
        new_size_writer.is_null() ? nullptr : new_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->new_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null new_size in VisualProperties struct");
    decltype(Traits::visible_viewport_size(input)) in_visible_viewport_size = Traits::visible_viewport_size(input);
    typename decltype((*output)->visible_viewport_size)::BaseType::BufferWriter
        visible_viewport_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_visible_viewport_size, buffer, &visible_viewport_size_writer, context);
    (*output)->visible_viewport_size.Set(
        visible_viewport_size_writer.is_null() ? nullptr : visible_viewport_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->visible_viewport_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visible_viewport_size in VisualProperties struct");
    decltype(Traits::compositor_viewport_pixel_rect(input)) in_compositor_viewport_pixel_rect = Traits::compositor_viewport_pixel_rect(input);
    typename decltype((*output)->compositor_viewport_pixel_rect)::BaseType::BufferWriter
        compositor_viewport_pixel_rect_writer;
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_compositor_viewport_pixel_rect, buffer, &compositor_viewport_pixel_rect_writer, context);
    (*output)->compositor_viewport_pixel_rect.Set(
        compositor_viewport_pixel_rect_writer.is_null() ? nullptr : compositor_viewport_pixel_rect_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->compositor_viewport_pixel_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null compositor_viewport_pixel_rect in VisualProperties struct");
    decltype(Traits::browser_controls_params(input)) in_browser_controls_params = Traits::browser_controls_params(input);
    typename decltype((*output)->browser_controls_params)::BaseType::BufferWriter
        browser_controls_params_writer;
    mojo::internal::Serialize<::cc::mojom::BrowserControlsParamsDataView>(
        in_browser_controls_params, buffer, &browser_controls_params_writer, context);
    (*output)->browser_controls_params.Set(
        browser_controls_params_writer.is_null() ? nullptr : browser_controls_params_writer.data());
    (*output)->scroll_focused_node_into_view = Traits::scroll_focused_node_into_view(input);
    decltype(Traits::local_surface_id(input)) in_local_surface_id = Traits::local_surface_id(input);
    typename decltype((*output)->local_surface_id)::BaseType::BufferWriter
        local_surface_id_writer;
    mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
        in_local_surface_id, buffer, &local_surface_id_writer, context);
    (*output)->local_surface_id.Set(
        local_surface_id_writer.is_null() ? nullptr : local_surface_id_writer.data());
    (*output)->is_fullscreen_granted = Traits::is_fullscreen_granted(input);
    mojo::internal::Serialize<::blink::mojom::DisplayMode>(
        Traits::display_mode(input), &(*output)->display_mode);
    (*output)->capture_sequence_number = Traits::capture_sequence_number(input);
    (*output)->zoom_level = Traits::zoom_level(input);
    (*output)->page_scale_factor = Traits::page_scale_factor(input);
    decltype(Traits::root_widget_window_segments(input)) in_root_widget_window_segments = Traits::root_widget_window_segments(input);
    typename decltype((*output)->root_widget_window_segments)::BaseType::BufferWriter
        root_widget_window_segments_writer;
    const mojo::internal::ContainerValidateParams root_widget_window_segments_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
        in_root_widget_window_segments, buffer, &root_widget_window_segments_writer, &root_widget_window_segments_validate_params,
        context);
    (*output)->root_widget_window_segments.Set(
        root_widget_window_segments_writer.is_null() ? nullptr : root_widget_window_segments_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->root_widget_window_segments.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null root_widget_window_segments in VisualProperties struct");
    (*output)->is_pinch_gesture_active = Traits::is_pinch_gesture_active(input);
  }

  static bool Deserialize(::blink::mojom::internal::VisualProperties_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::VisualPropertiesDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void VisualPropertiesDataView::GetScreenInfoDataView(
    ::blink::mojom::ScreenInfoDataView* output) {
  auto pointer = data_->screen_info.Get();
  *output = ::blink::mojom::ScreenInfoDataView(pointer, context_);
}
inline void VisualPropertiesDataView::GetMinSizeForAutoResizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->min_size_for_auto_resize.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void VisualPropertiesDataView::GetMaxSizeForAutoResizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->max_size_for_auto_resize.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void VisualPropertiesDataView::GetNewSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->new_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void VisualPropertiesDataView::GetVisibleViewportSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->visible_viewport_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void VisualPropertiesDataView::GetCompositorViewportPixelRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->compositor_viewport_pixel_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, context_);
}
inline void VisualPropertiesDataView::GetBrowserControlsParamsDataView(
    ::cc::mojom::BrowserControlsParamsDataView* output) {
  auto pointer = data_->browser_controls_params.Get();
  *output = ::cc::mojom::BrowserControlsParamsDataView(pointer, context_);
}
inline void VisualPropertiesDataView::GetLocalSurfaceIdDataView(
    ::viz::mojom::LocalSurfaceIdDataView* output) {
  auto pointer = data_->local_surface_id.Get();
  *output = ::viz::mojom::LocalSurfaceIdDataView(pointer, context_);
}
inline void VisualPropertiesDataView::GetRootWidgetWindowSegmentsDataView(
    mojo::ArrayDataView<::gfx::mojom::RectDataView>* output) {
  auto pointer = data_->root_widget_window_segments.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::RectDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_SHARED_H_