// ui/accessibility/mojom/ax_tree_id.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_TREE_ID_MOJOM_SHARED_INTERNAL_H_
#define UI_ACCESSIBILITY_MOJOM_AX_TREE_ID_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "ui/accessibility/ax_enums.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace ax {
namespace mojom {
namespace internal {
class AXTreeID_Data;

#pragma pack(push, 1)


class  AXTreeID_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  AXTreeID_Data() {}
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~AXTreeID_Data() {}

  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(AXTreeID_Data));
      new (data()) AXTreeID_Data();
    }

    void AllocateInline(mojo::internal::Buffer* serialization_buffer,
                        void* ptr) {
      const char* start = static_cast<const char*>(
          serialization_buffer->data());
      const char* slot = static_cast<const char*>(ptr);
      DCHECK_GT(slot, start);
      serialization_buffer_ = serialization_buffer;
      index_ = slot - start;
      new (data()) AXTreeID_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    AXTreeID_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<AXTreeID_Data>(index_);
    }
    AXTreeID_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<AXTreeID_Tag>(0);
    data.unknown = 0U;
  }

  enum class AXTreeID_Tag : uint32_t {

    
    UNKNOWN,
    
    TOKEN,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    uint8_t f_unknown;
    mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> f_token;
    uint64_t unknown;
  };

  uint32_t size;
  AXTreeID_Tag tag;
  Union_ data;
};
static_assert(sizeof(AXTreeID_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(AXTreeID_Data)");

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace ax

#endif  // UI_ACCESSIBILITY_MOJOM_AX_TREE_ID_MOJOM_SHARED_INTERNAL_H_