// ui/base/cursor/mojom/cursor.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_CURSOR_MOJOM_CURSOR_MOJOM_SHARED_H_
#define UI_BASE_CURSOR_MOJOM_CURSOR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ui/base/cursor/mojom/cursor.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/base/cursor/mojom/cursor_type.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace ui {
namespace mojom {
class CursorDataView;



}  // namespace mojom
}  // namespace ui

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ui::mojom::CursorDataView> {
  using Data = ::ui::mojom::internal::Cursor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ui {
namespace mojom {


class CursorDataView {
 public:
  CursorDataView() {}

  CursorDataView(
      internal::Cursor_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::ui::mojom::CursorType>(
        data_value, output);
  }

  ::ui::mojom::CursorType type() const {
    return static_cast<::ui::mojom::CursorType>(data_->type);
  }
  inline void GetHotspotDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHotspot(UserType* output) {
    
    auto* pointer = data_->hotspot.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, context_);
  }
  inline void GetBitmapDataView(
      ::skia::mojom::BitmapDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBitmap(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::BitmapDataView, UserType>(),
    "Attempting to read the optional `bitmap` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBitmap` instead "
    "of `ReadBitmap if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bitmap.Get();
    return mojo::internal::Deserialize<::skia::mojom::BitmapDataView>(
        pointer, output, context_);
  }
  float image_scale_factor() const {
    return data_->image_scale_factor;
  }
 private:
  internal::Cursor_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace ui

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::CursorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::CursorDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::ui::mojom::internal::Cursor_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::ui::mojom::CursorType>(
        Traits::type(input), &(*output)->type);
    decltype(Traits::hotspot(input)) in_hotspot = Traits::hotspot(input);
    typename decltype((*output)->hotspot)::BaseType::BufferWriter
        hotspot_writer;
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
        in_hotspot, buffer, &hotspot_writer, context);
    (*output)->hotspot.Set(
        hotspot_writer.is_null() ? nullptr : hotspot_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->hotspot.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hotspot in Cursor struct");
    decltype(Traits::bitmap(input)) in_bitmap = Traits::bitmap(input);
    typename decltype((*output)->bitmap)::BaseType::BufferWriter
        bitmap_writer;
    mojo::internal::Serialize<::skia::mojom::BitmapDataView>(
        in_bitmap, buffer, &bitmap_writer, context);
    (*output)->bitmap.Set(
        bitmap_writer.is_null() ? nullptr : bitmap_writer.data());
    (*output)->image_scale_factor = Traits::image_scale_factor(input);
  }

  static bool Deserialize(::ui::mojom::internal::Cursor_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::CursorDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ui {
namespace mojom {

inline void CursorDataView::GetHotspotDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->hotspot.Get();
  *output = ::gfx::mojom::PointDataView(pointer, context_);
}
inline void CursorDataView::GetBitmapDataView(
    ::skia::mojom::BitmapDataView* output) {
  auto pointer = data_->bitmap.Get();
  *output = ::skia::mojom::BitmapDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace ui

#endif  // UI_BASE_CURSOR_MOJOM_CURSOR_MOJOM_SHARED_H_