// ui/gl/mojom/hdr_metadata.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GL_MOJOM_HDR_METADATA_MOJOM_SHARED_H_
#define UI_GL_MOJOM_HDR_METADATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ui/gl/mojom/hdr_metadata.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"







namespace gl {
namespace mojom {
class MasteringMetadataDataView;

class HDRMetadataDataView;



}  // namespace mojom
}  // namespace gl

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gl::mojom::MasteringMetadataDataView> {
  using Data = ::gl::mojom::internal::MasteringMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gl::mojom::HDRMetadataDataView> {
  using Data = ::gl::mojom::internal::HDRMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gl {
namespace mojom {


class MasteringMetadataDataView {
 public:
  MasteringMetadataDataView() {}

  MasteringMetadataDataView(
      internal::MasteringMetadata_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPrimaryRDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPrimaryR(UserType* output) {
    
    auto* pointer = data_->primary_r.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, context_);
  }
  inline void GetPrimaryGDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPrimaryG(UserType* output) {
    
    auto* pointer = data_->primary_g.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, context_);
  }
  inline void GetPrimaryBDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPrimaryB(UserType* output) {
    
    auto* pointer = data_->primary_b.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, context_);
  }
  inline void GetWhitePointDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWhitePoint(UserType* output) {
    
    auto* pointer = data_->white_point.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, context_);
  }
  float luminance_max() const {
    return data_->luminance_max;
  }
  float luminance_min() const {
    return data_->luminance_min;
  }
 private:
  internal::MasteringMetadata_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class HDRMetadataDataView {
 public:
  HDRMetadataDataView() {}

  HDRMetadataDataView(
      internal::HDRMetadata_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetMasteringMetadataDataView(
      MasteringMetadataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMasteringMetadata(UserType* output) {
    
    auto* pointer = data_->mastering_metadata.Get();
    return mojo::internal::Deserialize<::gl::mojom::MasteringMetadataDataView>(
        pointer, output, context_);
  }
  uint32_t max_content_light_level() const {
    return data_->max_content_light_level;
  }
  uint32_t max_frame_average_light_level() const {
    return data_->max_frame_average_light_level;
  }
 private:
  internal::HDRMetadata_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace gl

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gl::mojom::MasteringMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gl::mojom::MasteringMetadataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gl::mojom::internal::MasteringMetadata_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::primary_r(input)) in_primary_r = Traits::primary_r(input);
    typename decltype((*output)->primary_r)::BaseType::BufferWriter
        primary_r_writer;
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_primary_r, buffer, &primary_r_writer, context);
    (*output)->primary_r.Set(
        primary_r_writer.is_null() ? nullptr : primary_r_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->primary_r.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null primary_r in MasteringMetadata struct");
    decltype(Traits::primary_g(input)) in_primary_g = Traits::primary_g(input);
    typename decltype((*output)->primary_g)::BaseType::BufferWriter
        primary_g_writer;
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_primary_g, buffer, &primary_g_writer, context);
    (*output)->primary_g.Set(
        primary_g_writer.is_null() ? nullptr : primary_g_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->primary_g.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null primary_g in MasteringMetadata struct");
    decltype(Traits::primary_b(input)) in_primary_b = Traits::primary_b(input);
    typename decltype((*output)->primary_b)::BaseType::BufferWriter
        primary_b_writer;
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_primary_b, buffer, &primary_b_writer, context);
    (*output)->primary_b.Set(
        primary_b_writer.is_null() ? nullptr : primary_b_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->primary_b.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null primary_b in MasteringMetadata struct");
    decltype(Traits::white_point(input)) in_white_point = Traits::white_point(input);
    typename decltype((*output)->white_point)::BaseType::BufferWriter
        white_point_writer;
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_white_point, buffer, &white_point_writer, context);
    (*output)->white_point.Set(
        white_point_writer.is_null() ? nullptr : white_point_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->white_point.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null white_point in MasteringMetadata struct");
    (*output)->luminance_max = Traits::luminance_max(input);
    (*output)->luminance_min = Traits::luminance_min(input);
  }

  static bool Deserialize(::gl::mojom::internal::MasteringMetadata_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gl::mojom::MasteringMetadataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gl::mojom::HDRMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gl::mojom::HDRMetadataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gl::mojom::internal::HDRMetadata_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::mastering_metadata(input)) in_mastering_metadata = Traits::mastering_metadata(input);
    typename decltype((*output)->mastering_metadata)::BaseType::BufferWriter
        mastering_metadata_writer;
    mojo::internal::Serialize<::gl::mojom::MasteringMetadataDataView>(
        in_mastering_metadata, buffer, &mastering_metadata_writer, context);
    (*output)->mastering_metadata.Set(
        mastering_metadata_writer.is_null() ? nullptr : mastering_metadata_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->mastering_metadata.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mastering_metadata in HDRMetadata struct");
    (*output)->max_content_light_level = Traits::max_content_light_level(input);
    (*output)->max_frame_average_light_level = Traits::max_frame_average_light_level(input);
  }

  static bool Deserialize(::gl::mojom::internal::HDRMetadata_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gl::mojom::HDRMetadataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gl {
namespace mojom {

inline void MasteringMetadataDataView::GetPrimaryRDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->primary_r.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, context_);
}
inline void MasteringMetadataDataView::GetPrimaryGDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->primary_g.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, context_);
}
inline void MasteringMetadataDataView::GetPrimaryBDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->primary_b.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, context_);
}
inline void MasteringMetadataDataView::GetWhitePointDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->white_point.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, context_);
}


inline void HDRMetadataDataView::GetMasteringMetadataDataView(
    MasteringMetadataDataView* output) {
  auto pointer = data_->mastering_metadata.Get();
  *output = MasteringMetadataDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace gl

#endif  // UI_GL_MOJOM_HDR_METADATA_MOJOM_SHARED_H_