# This file will contain variables that hold regex strings to match for positive
# value matches.
# https://www.drupal.org/docs/develop/coding-standards/list-of-sql-reserved-words
# https://docs.microsoft.com/en-us/sql/t-sql/language-elements/reserved-keywords-transact-sql

import re

sqlRegex = [
    ".*(?i)ABORT.*",
    ".*(?i)ABS.*",
    ".*(?i)ABSOLUTE.*",
    ".*(?i)ACCESS.*",
    ".*(?i)ACTION.*",
    ".*(?i)ADA.*",
    ".*(?i)ADD.*",
    ".*(?i)ADMIN.*",
    ".*(?i)AFTER.*",
    ".*(?i)AGGREGATE.*",
    ".*(?i)ALIAS.*",
    ".*(?i)ALL.*",
    ".*(?i)ALLOCATE.*",
    ".*(?i)ALSO.*",
    ".*(?i)ALTER.*",
    ".*(?i)ALWAYS.*",
    ".*(?i)ANALYSE.*",
    ".*(?i)ANALYZE.*",
    ".*[\ \+]{1}(?i)AND[\ \+\(]{1}.*",
    ".*(?i)ANY.*",
    ".*(?i)ARE.*",
    ".*(?i)ARRAY.*",
    ".* (?i)AS .*",
    ".*[\ \+]{1}(?i)AS[\ \+\(]{1}.*",
    ".*(?i)ASC.*",
    ".*(?i)ASENSITIVE.*",
    ".*(?i)ASSERTION.*",
    ".*(?i)ASSIGNMENT.*",
    ".*(?i)ASYMMETRIC.*",
    ".*[\ \+]{1}(?i)AT[\ \+\(]{1}.*",
    ".*(?i)ATOMIC.*",
    ".*(?i)ATTRIBUTE.*",
    ".*(?i)ATTRIBUTES.*",
    ".*(?i)AUDIT.*",
    ".*(?i)AUTHORIZATION.*",
    ".*(?i)AUTO_INCREMENT.*",
    ".*(?i)AVG.*",
    ".*(?i)AVG_ROW_LENGTH.*",
    ".*(?i)BACKUP.*",
    ".*(?i)BACKWARD.*",
    ".*(?i)BEFORE.*",
    ".*(?i)BEGIN.*",
    ".*(?i)BERNOULLI.*",
    ".*(?i)BETWEEN.*",
    ".*(?i)BIGINT.*",
    ".*(?i)BINARY.*",
    ".*(?i)BIT.*",
    ".*(?i)BIT_LENGTH.*",
    ".*(?i)BITVAR.*",
    ".*(?i)BLOB.*",
    ".*(?i)BOOL.*",
    ".*(?i)BOOLEAN.*",
    ".*(?i)BOTH.*",
    ".*(?i)BREADTH.*",
    ".*(?i)BREAK.*",
    ".*(?i)BROWSE.*",
    ".*(?i)BULK.*",
    ".*[\ \+]{1}(?i)BY[\ \+\(]{1}.*",
    ".*(?i)CACHE.*",
    ".*(?i)CALL.*",
    ".*(?i)CALLED.*",
    ".*(?i)CARDINALITY.*",
    ".*(?i)CASCADE.*",
    ".*(?i)CASCADED.*",
    ".*(?i)CASE.*",
    ".*(?i)CAST.*",
    ".*(?i)CATALOG.*",
    ".*(?i)CATALOG_NAME.*",
    ".*(?i)CEIL.*",
    ".*(?i)CEILING.*",
    ".*(?i)CHAIN.*",
    ".*(?i)CHANGE.*",
    ".*(?i)CHAR.*",
    ".*(?i)CHARACTER.*",
    ".*(?i)CHARACTERISTICS.*",
    ".*(?i)CHARACTER_LENGTH.*",
    ".*(?i)CHARACTERS.*",
    ".*(?i)CHARACTER_SET_CATALOG.*",
    ".*(?i)CHARACTER_SET_NAME.*",
    ".*(?i)CHARACTER_SET_SCHEMA.*",
    ".*(?i)CHAR_LENGTH.*",
    ".*(?i)CHECK.*",
    ".*(?i)CHECKED.*",
    ".*(?i)CHECKPOINT.*",
    ".*(?i)CHECKSUM.*",
    ".*(?i)CLASS.*",
    ".*(?i)CLASS_ORIGIN.*",
    ".*(?i)CLOB.*",
    ".*(?i)CLOSE.*",
    ".*(?i)CLUSTER.*",
    ".*(?i)CLUSTERED.*",
    ".*(?i)COALESCE.*",
    ".*(?i)COBOL.*",
    ".*(?i)COLLATE.*",
    ".*(?i)COLLATION.*",
    ".*(?i)COLLATION_CATALOG.*",
    ".*(?i)COLLATION_NAME.*",
    ".*(?i)COLLATION_SCHEMA.*",
    ".*(?i)COLLECT.*",
    ".*(?i)COLUMN.*",
    ".*(?i)COLUMN_NAME.*",
    ".*(?i)COLUMNS.*",
    ".*(?i)COMMAND_FUNCTION.*",
    ".*(?i)COMMAND_FUNCTION_CODE.*",
    ".*(?i)COMMENT.*",
    ".*(?i)COMMIT.*",
    ".*(?i)COMMITTED.*",
    ".*(?i)COMPLETION.*",
    ".*(?i)COMPRESS.*",
    ".*(?i)COMPUTE.*",
    ".*(?i)CONDITION.*",
    ".*(?i)CONDITION_NUMBER.*",
    ".*(?i)CONNECT.*",
    ".*(?i)CONNECTION.*",
    ".*(?i)CONNECTION_NAME.*",
    ".*(?i)CONSTRAINT.*",
    ".*(?i)CONSTRAINT_CATALOG.*",
    ".*(?i)CONSTRAINT_NAME.*",
    ".*(?i)CONSTRAINTS.*",
    ".*(?i)CONSTRAINT_SCHEMA.*",
    ".*(?i)CONSTRUCTOR.*",
    ".*(?i)CONTAINS.*",
    ".*(?i)CONTAINSTABLE.*",
    ".*(?i)CONTINUE.*",
    ".*(?i)CONVERSION.*",
    ".*(?i)CONVERT.*",
    ".*(?i)COPY.*",
    ".*(?i)CORR.*",
    ".*(?i)CORRESPONDING.*",
    ".*(?i)COUNT.*",
    ".*(?i)COVAR_POP.*",
    ".*(?i)COVAR_SAMP.*",
    ".*(?i)CREATE.*",
    ".*(?i)CREATEDB.*",
    ".*(?i)CREATEROLE.*",
    ".*(?i)CREATEUSER.*",
    ".*(?i)CROSS.*",
    ".*(?i)CSV.*",
    ".*(?i)CUBE.*",
    ".*(?i)CUME_DIST.*",
    ".*(?i)CURRENT.*",
    ".*(?i)CURRENT_DATE.*",
    ".*(?i)CURRENT_DEFAULT_TRANSFORM_GROUP.*",
    ".*(?i)CURRENT_PATH.*",
    ".*(?i)CURRENT_ROLE.*",
    ".*(?i)CURRENT_TIME.*",
    ".*(?i)CURRENT_TIMESTAMP.*",
    ".*(?i)CURRENT_TRANSFORM_GROUP_FOR_TYPE.*",
    ".*(?i)CURRENT_USER.*",
    ".*(?i)CURSOR.*",
    ".*(?i)CURSOR_NAME.*",
    ".*(?i)CYCLE.*",
    ".*(?i)DATA.*",
    ".*(?i)DATABASE.*",
    ".*(?i)DATABASES.*",
    ".*(?i)DATE.*",
    ".*(?i)DATETIME.*",
    ".*(?i)DATETIME_INTERVAL_CODE.*",
    ".*(?i)DATETIME_INTERVAL_PRECISION.*",
    ".*(?i)DAY.*",
    ".*(?i)DAY_HOUR.*",
    ".*(?i)DAY_MICROSECOND.*",
    ".*(?i)DAY_MINUTE.*",
    ".*(?i)DAYOFMONTH.*",
    ".*(?i)DAYOFWEEK.*",
    ".*(?i)DAYOFYEAR.*",
    ".*(?i)DAY_SECOND.*",
    ".*(?i)DBCC.*",
    ".*(?i)DEALLOCATE.*",
    ".*(?i)DEC.*",
    ".*(?i)DECIMAL.*",
    ".*(?i)DECLARE.*",
    ".*(?i)DEFAULT.*",
    ".*(?i)DEFAULTS.*",
    ".*(?i)DEFERRABLE.*",
    ".*(?i)DEFERRED.*",
    ".*(?i)DEFINED.*",
    ".*(?i)DEFINER.*",
    ".*(?i)DEGREE.*",
    ".*(?i)DELAYED.*",
    ".*(?i)DELAY_KEY_WRITE.*",
    ".*(?i)DELETE.*",
    ".*(?i)DELIMITER.*",
    ".*(?i)DELIMITERS.*",
    ".*(?i)DENSE_RANK.*",
    ".*(?i)DENY.*",
    ".*(?i)DEPTH.*",
    ".*(?i)DEREF.*",
    ".*(?i)DERIVED.*",
    ".*(?i)DESC.*",
    ".*(?i)DESCRIBE.*",
    ".*(?i)DESCRIPTOR.*",
    ".*(?i)DESTROY.*",
    ".*(?i)DESTRUCTOR.*",
    ".*(?i)DETERMINISTIC.*",
    ".*(?i)DIAGNOSTICS.*",
    ".*(?i)DICTIONARY.*",
    ".*(?i)DISABLE.*",
    ".*(?i)DISCONNECT.*",
    ".*(?i)DISK.*",
    ".*(?i)DISPATCH.*",
    ".*(?i)DISTINCT.*",
    ".*(?i)DISTINCTROW.*",
    ".*(?i)DISTRIBUTED.*",
    ".*(?i)DIV.*",
    ".*[\ \+]{1}(?i)DO[\ \+\(]{1}.*",
    ".*(?i)DOMAIN.*",
    ".*(?i)DOUBLE.*",
    ".*(?i)DROP.*",
    ".*(?i)DUAL.*",
    ".*(?i)DUMMY.*",
    ".*(?i)DUMP.*",
    ".*(?i)DYNAMIC.*",
    ".*(?i)DYNAMIC_FUNCTION.*",
    ".*(?i)DYNAMIC_FUNCTION_CODE.*",
    ".*(?i)EACH.*",
    ".*(?i)ELEMENT.*",
    ".*(?i)ELSE.*",
    ".*(?i)ELSEIF.*",
    ".*(?i)ENABLE.*",
    ".*(?i)ENCLOSED.*",
    ".*(?i)ENCODING.*",
    ".*(?i)ENCRYPTED.*",
    ".*(?i)END.*",
    ".*(?i)END-EXEC.*",
    ".*(?i)ENUM.*",
    ".*(?i)EQUALS.*",
    ".*(?i)ERRLVL.*",
    ".*(?i)ESCAPE.*",
    ".*(?i)ESCAPED.*",
    ".*(?i)EVERY.*",
    ".*(?i)EXCEPT.*",
    ".*(?i)EXCEPTION.*",
    ".*(?i)EXCLUDE.*",
    ".*(?i)EXCLUDING.*",
    ".*(?i)EXCLUSIVE.*",
    ".*(?i)EXEC.*",
    ".*(?i)EXECUTE.*",
    ".*(?i)EXISTING.*",
    ".*(?i)EXISTS.*",
    ".*(?i)EXIT.*",
    ".*(?i)EXP.*",
    ".*(?i)EXPLAIN.*",
    ".*(?i)EXTERNAL.*",
    ".*(?i)EXTRACT.*",
    ".*(?i)FALSE.*",
    ".*(?i)FETCH.*",
    ".*(?i)FIELDS.*",
    ".*(?i)FILE.*",
    ".*(?i)FILLFACTOR.*",
    ".*(?i)FILTER.*",
    ".*(?i)FINAL.*",
    ".*(?i)FIRST.*",
    ".*(?i)FLOAT.*",
    ".*(?i)FLOAT4.*",
    ".*(?i)FLOAT8.*",
    ".*(?i)FLOOR.*",
    ".*(?i)FLUSH.*",
    ".*(?i)FOLLOWING.*",
    ".*(?i)FOR.*",
    ".*(?i)FORCE.*",
    ".*(?i)FOREIGN.*",
    ".*(?i)FORTRAN.*",
    ".*(?i)FORWARD.*",
    ".*(?i)FOUND.*",
    ".*(?i)FREE.*",
    ".*(?i)FREETEXT.*",
    ".*(?i)FREETEXTTABLE.*",
    ".*(?i)FREEZE.*",
    ".*(?i)FROM.*",
    ".*(?i)FULL.*",
    ".*(?i)FULLTEXT.*",
    ".*(?i)FUNCTION.*",
    ".*(?i)FUSION.*",
    ".*(?i)GENERAL.*",
    ".*(?i)GENERATED.*",
    ".*(?i)GET.*",
    ".*(?i)GLOBAL.*",
    ".*[\ \+]{1}(?i)GO[\ \+\(]{1}.*",
    ".*(?i)GOTO.*",
    ".*(?i)GRANT.*",
    ".*(?i)GRANTED.*",
    ".*(?i)GRANTS.*",
    ".*(?i)GREATEST.*",
    ".*(?i)GROUP.*",
    ".*(?i)GROUPING.*",
    ".*(?i)HANDLER.*",
    ".*(?i)HAVING.*",
    ".*(?i)HEADER.*",
    ".*(?i)HEAP.*",
    ".*(?i)HIERARCHY.*",
    ".*(?i)HIGH_PRIORITY.*",
    ".*(?i)HOLD.*",
    ".*(?i)HOLDLOCK.*",
    ".*(?i)HOST.*",
    ".*(?i)HOSTS.*",
    ".*(?i)HOUR.*",
    ".*(?i)HOUR_MICROSECOND.*",
    ".*(?i)HOUR_MINUTE.*",
    ".*(?i)HOUR_SECOND.*",
    ".*(?i)IDENTIFIED.*",
    ".*(?i)IDENTITY.*",
    ".*(?i)IDENTITYCOL.*",
    ".*(?i)IDENTITY_INSERT.*",
    ".*[\ \+]{1}(?i)IF[\ \+\(]{1}.*",
    ".*(?i)IGNORE.*",
    ".*(?i)ILIKE.*",
    ".*(?i)IMMEDIATE.*",
    ".*(?i)IMMUTABLE.*",
    ".*(?i)IMPLEMENTATION.*",
    ".*(?i)IMPLICIT.*",
    ".*[\ \+]{1}IN[\ \+\(]{1}.*",
    ".*(?i)INCLUDE.*",
    ".*(?i)INCLUDING.*",
    ".*(?i)INCREMENT.*",
    ".*(?i)INDEX.*",
    ".*(?i)INDICATOR.*",
    ".*(?i)INFILE.*",
    ".*(?i)INFIX.*",
    ".*(?i)INHERIT.*",
    ".*(?i)INHERITS.*",
    ".*(?i)INITIAL.*",
    ".*(?i)INITIALIZE.*",
    ".*(?i)INITIALLY.*",
    ".*(?i)INNER.*",
    ".*(?i)INOUT.*",
    ".*(?i)INPUT.*",
    ".*(?i)INSENSITIVE.*",
    ".*(?i)INSERT.*",
    ".*(?i)INSERT_ID.*",
    ".*(?i)INSTANCE.*",
    ".*(?i)INSTANTIABLE.*",
    ".*(?i)INSTEAD.*",
    ".*(?i)INT.*",
    ".*(?i)INT1.*",
    ".*(?i)INT2.*",
    ".*(?i)INT3.*",
    ".*(?i)INT4.*",
    ".*(?i)INT8.*",
    ".*(?i)INTEGER.*",
    ".*(?i)INTERSECT.*",
    ".*(?i)INTERSECTION.*",
    ".*(?i)INTERVAL.*",
    ".*(?i)INTO.*",
    ".*(?i)INVOKER.*",
    ".*[\ \+]{1}(?i)IS[\ \+\(]{1}.*",
    ".*(?i)ISAM.*",
    ".*(?i)ISNULL.*",
    ".*(?i)ISOLATION.*",
    ".*(?i)ITERATE.*",
    ".*(?i)JOIN.*",
    ".*(?i)KEY.*",
    ".*(?i)KEY_MEMBER.*",
    ".*(?i)KEYS.*",
    ".*(?i)KEY_TYPE.*",
    ".*(?i)KILL.*",
    ".*(?i)LANCOMPILER.*",
    ".*(?i)LANGUAGE.*",
    ".*(?i)LARGE.*",
    ".*(?i)LAST.*",
    ".*(?i)LAST_INSERT_ID.*",
    ".*(?i)LATERAL.*",
    ".*(?i)LEADING.*",
    ".*(?i)LEAST.*",
    ".*(?i)LEAVE.*",
    ".*(?i)LEFT.*",
    ".*(?i)LENGTH.*",
    ".*(?i)LESS.*",
    ".*(?i)LEVEL.*",
    ".*(?i)LIKE.*",
    ".*(?i)LIMIT.*",
    ".*(?i)LINENO.*",
    ".*(?i)LINES.*",
    ".*(?i)LISTEN.*",
    ".*(?i)LN\(.*",
    ".*(?i)LOAD.*",
    ".*(?i)LOCAL.*",
    ".*(?i)LOCALTIME.*",
    ".*(?i)LOCALTIMESTAMP.*",
    ".*(?i)LOCATION.*",
    ".*(?i)LOCATOR.*",
    ".*(?i)LOCK.*",
    ".*(?i)LOGIN.*",
    ".*(?i)LOGS.*",
    ".*(?i)LONG.*",
    ".*(?i)LONGBLOB.*",
    ".*(?i)LONGTEXT.*",
    ".*(?i)LOOP.*",
    ".*(?i)LOWER.*",
    ".*(?i)LOW_PRIORITY.*",
    ".*(?i)MAP.*",
    ".*(?i)MATCH.*",
    ".*(?i)MATCHED.*",
    ".*(?i)MAX.*",
    ".*(?i)MAXEXTENTS.*",
    ".*(?i)MAX_ROWS.*",
    ".*(?i)MAXVALUE.*",
    ".*(?i)MEDIUMBLOB.*",
    ".*(?i)MEDIUMINT.*",
    ".*(?i)MEDIUMTEXT.*",
    ".*(?i)MEMBER.*",
    ".*(?i)MERGE.*",
    ".*(?i)MESSAGE_LENGTH.*",
    ".*(?i)MESSAGE_OCTET_LENGTH.*",
    ".*(?i)MESSAGE_TEXT.*",
    ".*(?i)METHOD.*",
    ".*(?i)MIDDLEINT.*",
    ".*(?i)MIN.*",
    ".*(?i)MIN_ROWS.*",
    ".*(?i)MINUS.*",
    ".*(?i)MINUTE.*",
    ".*(?i)MINUTE_MICROSECOND.*",
    ".*(?i)MINUTE_SECOND.*",
    ".*(?i)MINVALUE.*",
    ".*(?i)MLSLABEL.*",
    ".*(?i)MOD.*",
    ".*(?i)MODE.*",
    ".*(?i)MODIFIES.*",
    ".*(?i)MODIFY.*",
    ".*(?i)MODULE.*",
    ".*(?i)MONTH.*",
    ".*(?i)MONTHNAME.*",
    ".*(?i)MORE.*",
    ".*(?i)MOVE.*",
    ".*(?i)MULTISET.*",
    ".*(?i)MUMPS.*",
    ".*(?i)MYISAM.*",
    ".*(?i)NAME.*",
    ".*(?i)NAMES.*",
    ".*(?i)NATIONAL.*",
    ".*(?i)NATURAL.*",
    ".*(?i)NCHAR.*",
    ".*(?i)NCLOB.*",
    ".*(?i)NESTING.*",
    ".*(?i)NEW.*",
    ".*(?i)NEXT.*",
    ".*(?i)NO.*",
    ".*(?i)NOAUDIT.*",
    ".*(?i)NOCHECK.*",
    ".*(?i)NOCOMPRESS.*",
    ".*(?i)NOCREATEDB.*",
    ".*(?i)NOCREATEROLE.*",
    ".*(?i)NOCREATEUSER.*",
    ".*(?i)NOINHERIT.*",
    ".*(?i)NOLOGIN.*",
    ".*(?i)NONCLUSTERED.*",
    # ".*(?i)NONE.*",
    ".*(?i)NORMALIZE.*",
    ".*(?i)NORMALIZED.*",
    ".*(?i)NOSUPERUSER.*",
    ".*(?i)NOT.*",
    ".*(?i)NOTHING.*",
    ".*(?i)NOTIFY.*",
    ".*(?i)NOTNULL.*",
    ".*(?i)NOWAIT.*",
    ".*(?i)NO_WRITE_TO_BINLOG.*",
    ".*(?i)NULL.*",
    ".*(?i)NULLABLE.*",
    ".*(?i)NULLIF.*",
    ".*(?i)NULLS.*",
    ".*(?i)NUMBER.*",
    ".*(?i)NUMERIC.*",
    ".*(?i)OBJECT.*",
    ".*(?i)OCTET_LENGTH.*",
    ".*(?i)OCTETS.*",
    ".*[\ \+]{1}(?i)OF[\ \+\(]{1}.*",
    ".*(?i)OFF.*",
    ".*(?i)OFFLINE.*",
    ".*(?i)OFFSET.*",
    ".*(?i)OFFSETS.*",
    ".*(?i)OIDS.*",
    ".*(?i)OLD.*",
    ".*[\ \+]{1}(?i)ON[\ \+\(]{1}.*",
    ".*(?i)ONLINE.*",
    ".*(?i)ONLY.*",
    ".*(?i)OPEN.*",
    ".*(?i)OPENDATASOURCE.*",
    ".*(?i)OPENQUERY.*",
    ".*(?i)OPENROWSET.*",
    ".*(?i)OPENXML.*",
    ".*(?i)OPERATION.*",
    ".*(?i)OPERATOR.*",
    ".*(?i)OPTIMIZE.*",
    ".*(?i)OPTION.*",
    ".*(?i)OPTIONALLY.*",
    ".*(?i)OPTIONS.*",
    ".*[\ \+]{1}(?i)OR[\ \+\(]{1}.*"
    ".*(?i)ORDER.*",
    ".*(?i)ORDERING.*",
    ".*(?i)ORDINALITY.*",
    ".*(?i)OTHERS.*",
    ".*(?i)OUT.*",
    ".*(?i)OUTER.*",
    ".*(?i)OUTFILE.*",
    ".*(?i)OUTPUT.*",
    ".*(?i)OVER.*",
    ".*(?i)OVERLAPS.*",
    ".*(?i)OVERLAY.*",
    ".*(?i)OVERRIDING.*",
    ".*(?i)OWNER.*",
    ".*(?i)PACK_KEYS.*",
    ".*(?i)PAD.*",
    ".*(?i)PARAMETER.*",
    ".*(?i)PARAMETER_MODE.*",
    ".*(?i)PARAMETER_NAME.*",
    ".*(?i)PARAMETER_ORDINAL_POSITION.*",
    ".*(?i)PARAMETERS.*",
    ".*(?i)PARAMETER_SPECIFIC_CATALOG.*",
    ".*(?i)PARAMETER_SPECIFIC_NAME.*",
    ".*(?i)PARAMETER_SPECIFIC_SCHEMA.*",
    ".*(?i)PARTIAL.*",
    ".*(?i)PARTITION.*",
    ".*(?i)PASCAL.*",
    ".*(?i)PASSWORD.*",
    ".*(?i)PATH.*",
    ".*(?i)PCTFREE.*",
    ".*(?i)PERCENT.*",
    ".*(?i)PERCENTILE_CONT.*",
    ".*(?i)PERCENTILE_DISC.*",
    ".*(?i)PERCENT_RANK.*",
    ".*(?i)PIVOT.*",
    ".*(?i)PLACING.*",
    ".*(?i)PLAN.*",
    ".*(?i)PLI.*",
    ".*(?i)POSITION.*",
    ".*(?i)POSTFIX.*",
    ".*(?i)POWER.*",
    ".*(?i)PRECEDING.*",
    ".*(?i)PRECISION.*",
    ".*(?i)PREFIX.*",
    ".*(?i)PREORDER.*",
    ".*(?i)PREPARE.*",
    ".*(?i)PREPARED.*",
    ".*(?i)PRESERVE.*",
    ".*(?i)PRIMARY.*",
    ".*(?i)PRINT.*",
    ".*(?i)PRIOR.*",
    ".*(?i)PRIVILEGES.*",
    ".*(?i)PROC.*",
    ".*(?i)PROCEDURAL.*",
    ".*(?i)PROCEDURE.*",
    ".*(?i)PROCESS.*",
    ".*(?i)PROCESSLIST.*",
    ".*(?i)PUBLIC.*",
    ".*(?i)PURGE.*",
    ".*(?i)QUOTE.*",
    ".*(?i)RAID0.*",
    ".*(?i)RAISERROR.*",
    ".*(?i)RANGE.*",
    ".*(?i)RANK.*",
    ".*(?i)RAW.*",
    ".*(?i)READ.*",
    ".*(?i)READS.*",
    ".*(?i)READTEXT.*",
    ".*(?i)REAL.*",
    ".*(?i)RECHECK.*",
    ".*(?i)RECONFIGURE.*",
    ".*(?i)RECURSIVE.*",
    ".*(?i)REF.*",
    ".*(?i)REFERENCES.*",
    ".*(?i)REFERENCING.*",
    ".*(?i)REGEXP.*",
    ".*(?i)REGR_AVGX.*",
    ".*(?i)REGR_AVGY.*",
    ".*(?i)REGR_COUNT.*",
    ".*(?i)REGR_INTERCEPT.*",
    ".*(?i)REGR_R2.*",
    ".*(?i)REGR_SLOPE.*",
    ".*(?i)REGR_SXX.*",
    ".*(?i)REGR_SXY.*",
    ".*(?i)REGR_SYY.*",
    ".*(?i)REINDEX.*",
    ".*(?i)RELATIVE.*",
    ".*(?i)RELEASE.*",
    ".*(?i)RELOAD.*",
    ".*(?i)RENAME.*",
    ".*(?i)REPEAT.*",
    ".*(?i)REPEATABLE.*",
    ".*(?i)REPLACE.*",
    ".*(?i)REPLICATION.*",
    ".*(?i)REQUIRE.*",
    ".*(?i)RESET.*",
    ".*(?i)RESIGNAL.*",
    ".*(?i)RESOURCE.*",
    ".*(?i)RESTART.*",
    ".*(?i)RESTORE.*",
    ".*(?i)RESTRICT.*",
    ".*(?i)RESULT.*",
    ".*(?i)RETURN.*",
    ".*(?i)RETURNED_CARDINALITY.*",
    ".*(?i)RETURNED_LENGTH.*",
    ".*(?i)RETURNED_OCTET_LENGTH.*",
    ".*(?i)RETURNED_SQLSTATE.*",
    ".*(?i)RETURNS.*",
    ".*(?i)REVERT.*",
    ".*(?i)REVOKE.*",
    ".*(?i)RIGHT.*",
    ".*(?i)RLIKE.*",
    ".*(?i)ROLE.*",
    ".*(?i)ROLLBACK.*",
    ".*(?i)ROLLUP.*",
    ".*(?i)ROUTINE.*",
    ".*(?i)ROUTINE_CATALOG.*",
    ".*(?i)ROUTINE_NAME.*",
    ".*(?i)ROUTINE_SCHEMA.*",
    ".*(?i)ROW.*",
    ".*(?i)ROW_COUNT.*",
    ".*(?i)ROWCOUNT.*",
    ".*(?i)ROWGUIDCOL.*",
    ".*(?i)ROWID.*",
    ".*(?i)ROWNUM.*",
    ".*(?i)ROW_NUMBER.*",
    ".*(?i)ROWS.*",
    ".*(?i)RULE.*",
    ".*(?i)SAVE.*",
    ".*(?i)SAVEPOINT.*",
    ".*(?i)SCALE.*",
    ".*(?i)SCHEMA.*",
    ".*(?i)SCHEMA_NAME.*",
    ".*(?i)SCHEMAS.*",
    ".*(?i)SCOPE.*",
    ".*(?i)SCOPE_CATALOG.*",
    ".*(?i)SCOPE_NAME.*",
    ".*(?i)SCOPE_SCHEMA.*",
    ".*(?i)SCROLL.*",
    ".*(?i)SEARCH.*",
    ".*(?i)SECOND.*",
    ".*(?i)SECOND_MICROSECOND.*",
    ".*(?i)SECTION.*",
    ".*(?i)SECURITY.*",
    ".*(?i)SECURITYAUDIT.*",
    ".*(?i)SELECT.*",
    ".*(?i)SELF.*",
    ".*(?i)SEMANTICKEYPHRASETABLE.*",
    ".*(?i)SEMANTICSIMILARITYDETAILSTABLE.*",
    ".*(?i)SEMANTICSIMILARITYTABLE.*",
    ".*(?i)SENSITIVE.*",
    ".*(?i)SEPARATOR.*",
    ".*(?i)SEQUENCE.*",
    ".*(?i)SERIALIZABLE.*",
    ".*(?i)SERVER_NAME.*",
    ".*(?i)SESSION.*",
    ".*(?i)SESSION_USER.*",
    ".*(?i)SET.*",
    ".*(?i)SETOF.*",
    ".*(?i)SETS.*",
    ".*(?i)SETUSER.*",
    ".*(?i)SHARE.*",
    ".*(?i)SHOW.*",
    ".*(?i)SHUTDOWN.*",
    ".*(?i)SIGNAL.*",
    ".*(?i)SIMILAR.*",
    ".*(?i)SIMPLE.*",
    ".*(?i)SIZE.*",
    ".*(?i)SMALLINT.*",
    ".*(?i)SOME.*",
    ".*(?i)SONAME.*",
    ".*(?i)SOURCE.*",
    ".*(?i)SPACE.*",
    ".*(?i)SPATIAL.*",
    ".*(?i)SPECIFIC.*",
    ".*(?i)SPECIFIC_NAME.*",
    ".*(?i)SPECIFICTYPE.*",
    ".*(?i)SQL.*",
    ".*(?i)SQL_BIG_RESULT.*",
    ".*(?i)SQL_BIG_SELECTS.*",
    ".*(?i)SQL_BIG_TABLES.*",
    ".*(?i)SQLCA.*",
    ".*(?i)SQL_CALC_FOUND_ROWS.*",
    ".*(?i)SQLCODE.*",
    ".*(?i)SQLERROR.*",
    ".*(?i)SQLEXCEPTION.*",
    ".*(?i)SQL_LOG_OFF.*",
    ".*(?i)SQL_LOG_UPDATE.*",
    ".*(?i)SQL_LOW_PRIORITY_UPDATES.*",
    ".*(?i)SQL_SELECT_LIMIT.*",
    ".*(?i)SQL_SMALL_RESULT.*",
    ".*(?i)SQLSTATE.*",
    ".*(?i)SQLWARNING.*",
    ".*(?i)SQL_WARNINGS.*",
    ".*(?i)SQRT.*",
    ".*(?i)SSL.*",
    ".*(?i)STABLE.*",
    ".*(?i)START.*",
    ".*(?i)STARTING.*",
    ".*(?i)STATE.*",
    ".*(?i)STATEMENT.*",
    ".*(?i)STATIC.*",
    ".*(?i)STATISTICS.*",
    ".*(?i)STATUS.*",
    ".*(?i)STDDEV_POP.*",
    ".*(?i)STDDEV_SAMP.*",
    ".*(?i)STDIN.*",
    ".*(?i)STDOUT.*",
    ".*(?i)STORAGE.*",
    ".*(?i)STRAIGHT_JOIN.*",
    ".*(?i)STRICT.*",
    ".*(?i)STRING.*",
    ".*(?i)STRUCTURE.*",
    ".*(?i)STYLE.*",
    ".*(?i)SUBCLASS_ORIGIN.*",
    ".*(?i)SUBLIST.*",
    ".*(?i)SUBMULTISET.*",
    ".*(?i)SUBSTRING.*",
    ".*(?i)SUCCESSFUL.*",
    ".*(?i)SUM.*",
    ".*(?i)SUPERUSER.*",
    ".*(?i)SYMMETRIC.*",
    ".*(?i)SYNONYM.*",
    ".*(?i)SYSDATE.*",
    ".*(?i)SYSID.*",
    ".*(?i)SYSTEM.*",
    ".*(?i)SYSTEM_USER.*",
    ".*(?i)TABLE.*",
    ".*(?i)TABLE_NAME.*",
    ".*(?i)TABLES.*",
    ".*(?i)TABLESAMPLE.*",
    ".*(?i)TABLESPACE.*",
    ".*(?i)TEMP.*",
    ".*(?i)TEMPLATE.*",
    ".*(?i)TEMPORARY.*",
    ".*(?i)TERMINATE.*",
    ".*(?i)TERMINATED.*",
    ".*(?i)TEXT.*",
    ".*(?i)TEXTSIZE.*",
    ".*(?i)THAN.*",
    ".*(?i)THEN.*",
    ".*(?i)TIES.*",
    ".*(?i)TIME.*",
    ".*(?i)TIMESTAMP.*",
    ".*(?i)TIMEZONE_HOUR.*",
    ".*(?i)TIMEZONE_MINUTE.*",
    ".*(?i)TINYBLOB.*",
    ".*(?i)TINYINT.*",
    ".*(?i)TINYTEXT.*",
    ".*[\ \+]{1}(?i)TO[\ \+\(]{1}.*",
    ".*(?i)TOAST.*",
    ".*(?i)TOP.*",
    ".*(?i)TOP_LEVEL_COUNT.*",
    ".*(?i)TRAILING.*",
    ".*(?i)TRAN.*",
    ".*(?i)TRANSACTION.*",
    ".*(?i)TRANSACTION_ACTIVE.*",
    ".*(?i)TRANSACTIONS_COMMITTED.*",
    ".*(?i)TRANSACTIONS_ROLLED_BACK.*",
    ".*(?i)TRANSFORM.*",
    ".*(?i)TRANSFORMS.*",
    ".*(?i)TRANSLATE.*",
    ".*(?i)TRANSLATION.*",
    ".*(?i)TREAT.*",
    ".*(?i)TRIGGER.*",
    ".*(?i)TRIGGER_CATALOG.*",
    ".*(?i)TRIGGER_NAME.*",
    ".*(?i)TRIGGER_SCHEMA.*",
    ".*(?i)TRIM.*",
    ".*(?i)TRUE.*",
    ".*(?i)TRUNCATE.*",
    ".*(?i)TRUSTED.*",
    ".*(?i)TRY_CONVERT.*",
    ".*(?i)TSEQUAL.*",
    ".*(?i)TYPE.*",
    ".*(?i)UESCAPE.*",
    ".*(?i)UID.*",
    ".*(?i)UNBOUNDED.*",
    ".*(?i)UNCOMMITTED.*",
    ".*(?i)UNDER.*",
    ".*(?i)UNDO.*",
    ".*(?i)UNENCRYPTED.*",
    ".*(?i)UNION.*",
    ".*(?i)UNIQUE.*",
    ".*(?i)UNKNOWN.*",
    ".*(?i)UNLISTEN.*",
    ".*(?i)UNLOCK.*",
    ".*(?i)UNNAMED.*",
    ".*(?i)UNNEST.*",
    ".*(?i)UNPIVOT.*",
    ".*(?i)UNSIGNED.*",
    ".*(?i)UNTIL.*",
    ".*(?i)UPDATE.*",
    ".*(?i)UPDATETEXT.*",
    ".*(?i)UPPER.*",
    ".*(?i)USAGE.*",
    ".*(?i)USE.*",
    ".*(?i)USER.*",
    ".*(?i)USER_DEFINED_TYPE_CATALOG.*",
    ".*(?i)USER_DEFINED_TYPE_CODE.*",
    ".*(?i)USER_DEFINED_TYPE_NAME.*",
    ".*(?i)USER_DEFINED_TYPE_SCHEMA.*",
    ".*(?i)USING.*",
    ".*(?i)UTC_DATE.*",
    ".*(?i)UTC_TIME.*",
    ".*(?i)UTC_TIMESTAMP.*",
    ".*(?i)VACUUM.*",
    ".*(?i)VALID.*",
    ".*(?i)VALIDATE.*",
    ".*(?i)VALIDATOR.*",
    ".*(?i)VALUE.*",
    ".*(?i)VALUES.*",
    ".*(?i)VARBINARY.*",
    ".*(?i)VARCHAR.*",
    ".*(?i)VARCHAR2.*",
    ".*(?i)VARCHARACTER.*",
    ".*(?i)VARIABLE.*",
    ".*(?i)VARIABLES.*",
    ".*(?i)VAR_POP.*",
    ".*(?i)VAR_SAMP.*",
    ".*(?i)VARYING.*",
    ".*(?i)VERBOSE.*",
    ".*(?i)VIEW.*",
    ".*(?i)VOLATILE.*",
    ".*(?i)WAITFOR.*",
    ".*(?i)WHEN.*",
    ".*(?i)WHENEVER.*",
    ".*(?i)WHERE.*",
    ".*(?i)WHILE.*",
    ".*(?i)WIDTH_BUCKET.*",
    ".*(?i)WINDOW.*",
    ".*(?i)WITH.*",
    ".*(?i)WITHIN.*",
    ".*(?i)WITHIN GROUP.*",
    ".*(?i)WITHOUT.*",
    ".*(?i)WORK.*",
    ".*(?i)WRITE.*",
    ".*(?i)WRITETEXT.*",
    ".*(?i)X509.*",
    ".*(?i)XOR.*",
    ".*(?i)YEAR.*",
    ".*(?i)YEAR_MONTH.*",
    ".*(?i)ZEROFILL.*",
    ".*(?i)ZONE.*"
]

# Add additional regexes here

sqlRegex += [
    # This will match things like "userID, user_id, name1id, user-id, user.id"
    ".*[a-zA-Z0-9]+[._-]?(?i)id$",
    # only ID parameter (the classic)
    "^(?i)id$",
    # User added
    ".*(?i)TITLE.*",
    ".*(?i)CATEGORY.*",
    # taken from https://github.com/bugcrowd/HUNT/blob/master/Burp/conf/issues.json#L80 
    "(?i)report$",
    "(?i)query$",
    "(?i)sort$",
    "(?i)sel$",
    "(?i)results$",
    "(?i)sleep$",
    "(?i)order$",
    "(?i)keyword$",
    "(?i)field$",
    "(?i)string$",
    "(?i)number$"
]

# Add compiled data dicts here
compiledSql = [re.compile(x) for x in sqlRegex]
