/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.biginteger;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigInteger;
import java.util.Objects;

@XmlRootElement
public class BigIntegerAddModification
extends VariableModification<BigInteger> {
    @JsonProperty(required=true)
    private BigInteger summand;

    private BigIntegerAddModification() {
    }

    public BigIntegerAddModification(BigInteger summand) {
        this.summand = Objects.requireNonNull(summand, "Summand must not be null");
    }

    public BigIntegerAddModification(BigIntegerAddModification other) {
        this.summand = other.summand;
    }

    public BigIntegerAddModification createCopy() {
        return new BigIntegerAddModification(this);
    }

    @Override
    protected BigInteger modifyImplementationHook(BigInteger input) {
        if (input == null) {
            return null;
        }
        return input.add(this.summand);
    }

    public BigInteger getSummand() {
        return this.summand;
    }

    public void setSummand(BigInteger summand) {
        Objects.requireNonNull(summand, "Summand must not be null");
        this.summand = summand;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.summand);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntegerAddModification other = (BigIntegerAddModification)obj;
        return Objects.equals(this.summand, other.summand);
    }

    public String toString() {
        return "BigIntegerAddModification{summand=" + String.valueOf(this.summand) + "}";
    }
}

