/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.biginteger;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigInteger;

@XmlRootElement
public class BigIntegerShiftRightModification
extends VariableModification<BigInteger> {
    @JsonProperty(required=true)
    private int shift;

    private BigIntegerShiftRightModification() {
    }

    public BigIntegerShiftRightModification(int shift) {
        this.shift = shift;
    }

    public BigIntegerShiftRightModification(BigIntegerShiftRightModification other) {
        this.shift = other.shift;
    }

    public BigIntegerShiftRightModification createCopy() {
        return new BigIntegerShiftRightModification(this);
    }

    @Override
    protected BigInteger modifyImplementationHook(BigInteger input) {
        if (input == null) {
            return null;
        }
        return input.shiftRight(this.shift);
    }

    public int getShift() {
        return this.shift;
    }

    public void setShift(int shift) {
        this.shift = shift;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.shift;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntegerShiftRightModification other = (BigIntegerShiftRightModification)obj;
        return this.shift == other.shift;
    }

    public String toString() {
        return "BigIntegerShiftRightModification{shift=" + this.shift + "}";
    }
}

