/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.biginteger;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigInteger;
import java.util.Objects;

@XmlRootElement
public class BigIntegerSubtractModification
extends VariableModification<BigInteger> {
    @JsonProperty(required=true)
    private BigInteger subtrahend;

    private BigIntegerSubtractModification() {
    }

    public BigIntegerSubtractModification(BigInteger subtrahend) {
        this.subtrahend = Objects.requireNonNull(subtrahend, "Subtrahend must not be null");
    }

    public BigIntegerSubtractModification(BigIntegerSubtractModification other) {
        this.subtrahend = other.subtrahend;
    }

    public BigIntegerSubtractModification createCopy() {
        return new BigIntegerSubtractModification(this);
    }

    @Override
    protected BigInteger modifyImplementationHook(BigInteger input) {
        if (input == null) {
            return null;
        }
        return input.subtract(this.subtrahend);
    }

    public BigInteger getSubtrahend() {
        return this.subtrahend;
    }

    public void setSubtrahend(BigInteger subtrahend) {
        this.subtrahend = Objects.requireNonNull(subtrahend, "Subtrahend must not be null");
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.subtrahend);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntegerSubtractModification other = (BigIntegerSubtractModification)obj;
        return Objects.equals(this.subtrahend, other.subtrahend);
    }

    public String toString() {
        return "BigIntegerSubtractModification{subtrahend=" + String.valueOf(this.subtrahend) + "}";
    }
}

