/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.biginteger;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigInteger;
import java.util.Objects;

@XmlRootElement
public class BigIntegerXorModification
extends VariableModification<BigInteger> {
    @JsonProperty(required=true)
    private BigInteger xor;

    private BigIntegerXorModification() {
    }

    public BigIntegerXorModification(BigInteger xor) {
        this.xor = Objects.requireNonNull(xor, "Xor must not be null");
    }

    public BigIntegerXorModification(BigIntegerXorModification other) {
        this.xor = other.xor;
    }

    public BigIntegerXorModification createCopy() {
        return new BigIntegerXorModification(this);
    }

    @Override
    protected BigInteger modifyImplementationHook(BigInteger input) {
        if (input == null) {
            return null;
        }
        return input.xor(this.xor);
    }

    public BigInteger getXor() {
        return this.xor;
    }

    public void setXor(BigInteger xor) {
        this.xor = Objects.requireNonNull(xor, "Xor must not be null");
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.xor);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntegerXorModification other = (BigIntegerXorModification)obj;
        return Objects.equals(this.xor, other.xor);
    }

    public String toString() {
        return "BigIntegerXorModification{xor=" + String.valueOf(this.xor) + "}";
    }
}

