/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.biginteger;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.modifiablevariable.util.DataConverter;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigInteger;

@XmlRootElement
public class ModifiableBigInteger
extends ModifiableVariable<BigInteger> {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private BigInteger originalValue;

    public ModifiableBigInteger() {
    }

    public ModifiableBigInteger(BigInteger originalValue) {
        this.originalValue = originalValue;
    }

    public ModifiableBigInteger(ModifiableBigInteger other) {
        super(other);
        this.originalValue = other.originalValue;
    }

    public ModifiableBigInteger createCopy() {
        return new ModifiableBigInteger(this);
    }

    public BigInteger getAssertEquals() {
        return (BigInteger)this.assertEquals;
    }

    public void setAssertEquals(BigInteger assertEquals) {
        this.assertEquals = assertEquals;
    }

    @Override
    public boolean isOriginalValueModified() {
        if (this.getOriginalValue() == null) {
            throw new IllegalStateException("Original value must not be null");
        }
        return this.originalValue.compareTo((BigInteger)this.getValue()) != 0;
    }

    public byte[] getByteArray() {
        return DataConverter.bigIntegerToByteArray((BigInteger)this.getValue());
    }

    public byte[] getByteArray(int size) {
        return DataConverter.bigIntegerToByteArray((BigInteger)this.getValue(), size, true);
    }

    @Override
    public boolean validateAssertions() {
        if (this.assertEquals != null) {
            return ((BigInteger)this.assertEquals).compareTo((BigInteger)this.getValue()) == 0;
        }
        return true;
    }

    @Override
    public BigInteger getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public void setOriginalValue(BigInteger originalValue) {
        this.originalValue = originalValue;
    }

    public String toString() {
        return "ModifiableBigInteger{originalValue=" + String.valueOf(this.originalValue) + this.innerToString() + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModifiableBigInteger)) {
            return false;
        }
        ModifiableBigInteger that = (ModifiableBigInteger)obj;
        return this.getValue() != null ? ((BigInteger)this.getValue()).equals(that.getValue()) : that.getValue() == null;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.getValue() != null ? ((BigInteger)this.getValue()).hashCode() : 0);
        return result;
    }
}

