/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bool;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.rub.nds.modifiablevariable.ModifiableVariable;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ModifiableBoolean
extends ModifiableVariable<Boolean> {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean originalValue;

    public ModifiableBoolean() {
    }

    public ModifiableBoolean(Boolean originalValue) {
        this.originalValue = originalValue;
    }

    public ModifiableBoolean(ModifiableBoolean other) {
        super(other);
        this.originalValue = other.originalValue;
    }

    public ModifiableBoolean createCopy() {
        return new ModifiableBoolean(this);
    }

    @Override
    public Boolean getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public void setOriginalValue(Boolean originalValue) {
        this.originalValue = originalValue;
    }

    @Override
    public boolean isOriginalValueModified() {
        if (this.getOriginalValue() == null) {
            throw new IllegalStateException("Original value must not be null");
        }
        return this.originalValue.compareTo((Boolean)this.getValue()) != 0;
    }

    @Override
    public boolean validateAssertions() {
        if (this.assertEquals != null) {
            return ((Boolean)this.assertEquals).compareTo((Boolean)this.getValue()) == 0;
        }
        return true;
    }

    public String toString() {
        return "ModifiableBoolean{originalValue=" + this.originalValue + this.innerToString() + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModifiableBoolean)) {
            return false;
        }
        ModifiableBoolean that = (ModifiableBoolean)obj;
        Boolean thisValue = (Boolean)this.getValue();
        Boolean thatValue = (Boolean)that.getValue();
        return thisValue != null ? thisValue.equals(thatValue) : thatValue == null;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.getValue() != null ? ((Boolean)this.getValue()).hashCode() : 0);
        return result;
    }
}

