/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bytearray;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Arrays;
import java.util.Objects;

@XmlRootElement
public class ByteArrayAppendValueModification
extends VariableModification<byte[]> {
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    @JsonProperty(required=true)
    private byte[] bytesToAppend;

    private ByteArrayAppendValueModification() {
    }

    public ByteArrayAppendValueModification(byte[] bytesToAppend) {
        this.bytesToAppend = Objects.requireNonNull(bytesToAppend, "bytesToAppend must not be null");
    }

    public ByteArrayAppendValueModification(ByteArrayAppendValueModification other) {
        this.bytesToAppend = (byte[])other.bytesToAppend.clone();
    }

    public ByteArrayAppendValueModification createCopy() {
        return new ByteArrayAppendValueModification(this);
    }

    @Override
    protected byte[] modifyImplementationHook(byte[] input) {
        if (input == null) {
            return null;
        }
        return DataConverter.concatenate(input, this.bytesToAppend);
    }

    public byte[] getBytesToAppend() {
        return this.bytesToAppend;
    }

    public void setBytesToAppend(byte[] bytesToAppend) {
        this.bytesToAppend = Objects.requireNonNull(bytesToAppend, "BytesToAppend must not be null");
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Arrays.hashCode(this.bytesToAppend);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayAppendValueModification other = (ByteArrayAppendValueModification)obj;
        return Arrays.equals(this.bytesToAppend, other.bytesToAppend);
    }

    public String toString() {
        return "ByteArrayAppendValueModification{bytesToAppend=" + DataConverter.bytesToHexString(this.bytesToAppend) + "}";
    }
}

