/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bytearray;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.DataConverter;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Arrays;

@XmlRootElement
public class ByteArrayDeleteModification
extends VariableModification<byte[]> {
    @JsonProperty(required=true)
    private int count;
    @JsonProperty(required=true)
    private int startPosition;

    private ByteArrayDeleteModification() {
    }

    public ByteArrayDeleteModification(int startPosition, int count) {
        this.startPosition = startPosition;
        this.count = count;
    }

    public ByteArrayDeleteModification(ByteArrayDeleteModification other) {
        this.count = other.count;
        this.startPosition = other.startPosition;
    }

    public ByteArrayDeleteModification createCopy() {
        return new ByteArrayDeleteModification(this);
    }

    @Override
    protected byte[] modifyImplementationHook(byte[] input) {
        int deleteEndPosition;
        if (input == null) {
            return null;
        }
        if (input.length == 0) {
            return input;
        }
        int deleteStartPosition = this.startPosition % input.length;
        if (this.startPosition < 0) {
            deleteStartPosition += input.length - 1;
        }
        if ((deleteEndPosition = deleteStartPosition + Math.max(0, this.count)) > input.length) {
            deleteEndPosition = input.length;
        }
        byte[] ret1 = Arrays.copyOf(input, deleteStartPosition);
        if (deleteEndPosition < input.length) {
            byte[] ret2 = Arrays.copyOfRange(input, deleteEndPosition, input.length);
            return DataConverter.concatenate(ret1, ret2);
        }
        return ret1;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.count;
        hash = 31 * hash + this.startPosition;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayDeleteModification other = (ByteArrayDeleteModification)obj;
        if (this.count != other.count) {
            return false;
        }
        return this.startPosition == other.startPosition;
    }

    public String toString() {
        return "ByteArrayDeleteModification{count=" + this.count + ", startPosition=" + this.startPosition + "}";
    }
}

