/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bytearray;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Arrays;
import java.util.Objects;

@XmlRootElement
public class ByteArrayInsertValueModification
extends VariableModification<byte[]> {
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    @JsonProperty(required=true)
    private byte[] bytesToInsert;
    @JsonProperty(required=true)
    private int startPosition;

    private ByteArrayInsertValueModification() {
    }

    public ByteArrayInsertValueModification(byte[] bytesToInsert, int startPosition) {
        this.bytesToInsert = Objects.requireNonNull(bytesToInsert, "BytesToInsert must not be null");
        this.startPosition = startPosition;
    }

    public ByteArrayInsertValueModification(ByteArrayInsertValueModification other) {
        this.bytesToInsert = (byte[])other.bytesToInsert.clone();
        this.startPosition = other.startPosition;
    }

    public ByteArrayInsertValueModification createCopy() {
        return new ByteArrayInsertValueModification(this);
    }

    @Override
    protected byte[] modifyImplementationHook(byte[] input) {
        if (input == null) {
            return null;
        }
        int insertPosition = this.startPosition % (input.length + 1);
        if (this.startPosition < 0) {
            insertPosition += input.length;
        }
        byte[] ret1 = Arrays.copyOf(input, insertPosition);
        if (insertPosition < input.length) {
            byte[] ret2 = Arrays.copyOfRange(input, insertPosition, input.length);
            return DataConverter.concatenate(ret1, this.bytesToInsert, ret2);
        }
        return DataConverter.concatenate(ret1, this.bytesToInsert);
    }

    public byte[] getBytesToInsert() {
        return this.bytesToInsert;
    }

    public void setBytesToInsert(byte[] bytesToInsert) {
        this.bytesToInsert = Objects.requireNonNull(bytesToInsert, "bytesToInsert must not be null");
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Arrays.hashCode(this.bytesToInsert);
        hash = 31 * hash + this.startPosition;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayInsertValueModification other = (ByteArrayInsertValueModification)obj;
        if (this.startPosition != other.startPosition) {
            return false;
        }
        return Arrays.equals(this.bytesToInsert, other.bytesToInsert);
    }

    public String toString() {
        return "ByteArrayInsertModification{bytesToInsert=" + DataConverter.bytesToHexString(this.bytesToInsert) + ", startPosition=" + this.startPosition + "}";
    }
}

