/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bytearray;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Arrays;
import java.util.Objects;

@XmlRootElement
public class ByteArrayPrependValueModification
extends VariableModification<byte[]> {
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    @JsonProperty(required=true)
    private byte[] bytesToPrepend;

    private ByteArrayPrependValueModification() {
    }

    public ByteArrayPrependValueModification(byte[] bytesToPrepend) {
        this.bytesToPrepend = Objects.requireNonNull(bytesToPrepend, "bytesToPrepend must not be null");
    }

    public ByteArrayPrependValueModification(ByteArrayPrependValueModification other) {
        this.bytesToPrepend = (byte[])other.bytesToPrepend.clone();
    }

    public ByteArrayPrependValueModification createCopy() {
        return new ByteArrayPrependValueModification(this);
    }

    @Override
    protected byte[] modifyImplementationHook(byte[] input) {
        if (input == null) {
            return null;
        }
        return DataConverter.concatenate(this.bytesToPrepend, input);
    }

    public byte[] getBytesToPrepend() {
        return this.bytesToPrepend;
    }

    public void setBytesToPrepend(byte[] bytesToPrepend) {
        this.bytesToPrepend = Objects.requireNonNull(bytesToPrepend, "bytesToPrepend must not be null");
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Arrays.hashCode(this.bytesToPrepend);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayPrependValueModification other = (ByteArrayPrependValueModification)obj;
        return Arrays.equals(this.bytesToPrepend, other.bytesToPrepend);
    }

    public String toString() {
        return "ByteArrayPrependValueModification{bytesToPrepend=" + DataConverter.bytesToHexString(this.bytesToPrepend) + "}";
    }
}

