/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bytearray;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Arrays;
import java.util.Objects;

@XmlRootElement
public class ByteArrayShuffleModification
extends VariableModification<byte[]> {
    @JsonProperty(required=true)
    private int[] shuffle;

    private ByteArrayShuffleModification() {
    }

    public ByteArrayShuffleModification(int[] shuffle) {
        this.shuffle = Objects.requireNonNull(shuffle, "Shuffle pattern must not be null");
    }

    public ByteArrayShuffleModification(ByteArrayShuffleModification other) {
        this.shuffle = (int[])other.shuffle.clone();
    }

    public ByteArrayShuffleModification createCopy() {
        return new ByteArrayShuffleModification(this);
    }

    @Override
    protected byte[] modifyImplementationHook(byte[] input) {
        if (input == null) {
            return null;
        }
        if (input.length == 0) {
            return input;
        }
        byte[] result = (byte[])input.clone();
        int size = input.length;
        for (int i = 0; i < this.shuffle.length - 1; i += 2) {
            int p1 = (this.shuffle[i] & 0xFF) % size;
            int p2 = (this.shuffle[i + 1] & 0xFF) % size;
            byte tmp = result[p1];
            result[p1] = result[p2];
            result[p2] = tmp;
        }
        return result;
    }

    public int[] getShuffle() {
        return this.shuffle;
    }

    public void setShuffle(int[] shuffle) {
        this.shuffle = Objects.requireNonNull(shuffle, "Shuffle pattern must not be null");
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Arrays.hashCode(this.shuffle);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayShuffleModification other = (ByteArrayShuffleModification)obj;
        return Arrays.equals(this.shuffle, other.shuffle);
    }

    public String toString() {
        return "ByteArrayShuffleModification{shuffle=" + Arrays.toString(this.shuffle) + "}";
    }
}

