/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bytearray;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Arrays;
import java.util.Objects;

@XmlRootElement
public class ByteArrayXorModification
extends VariableModification<byte[]> {
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    @JsonProperty(required=true)
    private byte[] xor;
    @JsonProperty(required=true)
    private int startPosition;

    private ByteArrayXorModification() {
    }

    public ByteArrayXorModification(byte[] xor, int startPosition) {
        this.xor = Objects.requireNonNull(xor, "XOR array must not be null");
        this.startPosition = startPosition;
    }

    public ByteArrayXorModification(ByteArrayXorModification other) {
        this.xor = (byte[])other.xor.clone();
        this.startPosition = other.startPosition;
    }

    public ByteArrayXorModification createCopy() {
        return new ByteArrayXorModification(this);
    }

    @Override
    protected byte[] modifyImplementationHook(byte[] input) {
        int endPosition;
        if (input == null) {
            return null;
        }
        if (input.length == 0) {
            return input;
        }
        byte[] result = (byte[])input.clone();
        int xorPosition = this.startPosition % input.length;
        if (this.startPosition < 0) {
            xorPosition += input.length - 1;
        }
        if ((endPosition = xorPosition + this.xor.length) > result.length) {
            endPosition = result.length;
        }
        for (int i = 0; i < endPosition - xorPosition; ++i) {
            result[xorPosition + i] = (byte)(input[xorPosition + i] ^ this.xor[i]);
        }
        return result;
    }

    public byte[] getXor() {
        return this.xor;
    }

    public void setXor(byte[] xor) {
        this.xor = xor;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Arrays.hashCode(this.xor);
        hash = 31 * hash + this.startPosition;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayXorModification other = (ByteArrayXorModification)obj;
        if (this.startPosition != other.startPosition) {
            return false;
        }
        return Arrays.equals(this.xor, other.xor);
    }

    public String toString() {
        return "ByteArrayXorModification{xor=" + DataConverter.bytesToHexString(this.xor) + ", startPosition=" + this.startPosition + "}";
    }
}

