/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bytearray;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Arrays;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class ModifiableByteArray
extends ModifiableVariable<byte[]> {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private byte[] originalValue;

    public ModifiableByteArray() {
    }

    public ModifiableByteArray(byte[] originalValue) {
        this.originalValue = originalValue;
    }

    public ModifiableByteArray(ModifiableByteArray other) {
        super(other);
        this.originalValue = (byte[])other.originalValue.clone();
        if (other.assertEquals != null) {
            this.assertEquals = ((byte[])other.assertEquals).clone();
        }
    }

    public ModifiableByteArray createCopy() {
        return new ModifiableByteArray(this);
    }

    @Override
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    public byte[] getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public void setOriginalValue(byte[] originalValue) {
        this.originalValue = originalValue;
    }

    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    public byte[] getAssertEquals() {
        return (byte[])this.assertEquals;
    }

    public void setAssertEquals(byte[] assertEquals) {
        this.assertEquals = assertEquals;
    }

    @Override
    public boolean isOriginalValueModified() {
        if (this.originalValue == null) {
            throw new IllegalStateException("Original value must not be null");
        }
        return !Arrays.equals(this.originalValue, (byte[])this.getValue());
    }

    @Override
    public boolean validateAssertions() {
        boolean valid = true;
        if (this.assertEquals != null && !Arrays.equals((byte[])this.assertEquals, (byte[])this.getValue())) {
            valid = false;
        }
        return valid;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModifiableByteArray)) {
            return false;
        }
        ModifiableByteArray that = (ModifiableByteArray)obj;
        return Arrays.equals((byte[])this.getValue(), (byte[])that.getValue());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Arrays.hashCode((byte[])this.getValue());
        return result;
    }

    public String toString() {
        return "ModifiableByteArray{originalValue=" + (this.originalValue != null ? DataConverter.bytesToHexString(this.originalValue) : "") + this.innerToString() + "}";
    }
}

