/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.DataConverter;
import java.io.IOException;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ModifiableVariableModule
extends SimpleModule {
    private static final String MODULE_NAME = "ModifiableVariableModule";

    public ModifiableVariableModule() {
        super(MODULE_NAME);
        this.addSerializer(byte[].class, (JsonSerializer)new UnformattedByteArraySerializer());
        this.addDeserializer(byte[].class, (JsonDeserializer)new UnformattedByteArrayDeserializer());
        Reflections reflections = new Reflections("de.rub.nds.modifiablevariable", new Scanner[0]);
        reflections.getSubTypesOf(ModifiableVariable.class).forEach(xva$0 -> this.registerSubtypes(new Class[]{xva$0}));
        reflections.getSubTypesOf(VariableModification.class).forEach(xva$0 -> this.registerSubtypes(new Class[]{xva$0}));
    }

    public static VisibilityChecker<?> getFieldVisibilityChecker() {
        return VisibilityChecker.Std.defaultInstance().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
    }

    public static class UnformattedByteArraySerializer
    extends StdSerializer<byte[]> {
        public UnformattedByteArraySerializer() {
            super(byte[].class);
        }

        public void serialize(byte[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(DataConverter.bytesToRawHexString(value));
        }
    }

    public static class UnformattedByteArrayDeserializer
    extends StdDeserializer<byte[]> {
        public UnformattedByteArrayDeserializer() {
            super(byte[].class);
        }

        public byte[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return DataConverter.hexStringToByteArray(p.getText());
        }
    }
}

