/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.json;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.SubtypeResolver;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.TypeScope;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import com.github.victools.jsonschema.module.jackson.JsonIdentityReferenceDefinitionProvider;
import de.rub.nds.modifiablevariable.json.ReflectiveJacksonSchemaModule;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;

public class ObjectMapperSubTypesResolver
implements SubtypeResolver,
CustomDefinitionProviderV2 {
    private final CustomDefinition.DefinitionType wrappingSubtypeDefinitionType;
    private final boolean shouldInlineNestedSubtypes;
    private final Optional<JsonIdentityReferenceDefinitionProvider> identityReferenceProvider;
    private final ObjectMapper objectMapper;

    public ObjectMapperSubTypesResolver(ObjectMapper objectMapper, Collection<JacksonOption> options) {
        this.objectMapper = objectMapper;
        this.wrappingSubtypeDefinitionType = options.contains(JacksonOption.ALWAYS_REF_SUBTYPES) ? CustomDefinition.DefinitionType.ALWAYS_REF : CustomDefinition.DefinitionType.STANDARD;
        this.shouldInlineNestedSubtypes = options.contains(JacksonOption.INLINE_TRANSFORMED_SUBTYPES);
        this.identityReferenceProvider = options.contains(JacksonOption.JSONIDENTITY_REFERENCE_ALWAYS_AS_ID) ? Optional.of(new JsonIdentityReferenceDefinitionProvider()) : Optional.empty();
    }

    private boolean skipSubtypeResolution(ResolvedType declaredType, TypeContext context) {
        return this.identityReferenceProvider.flatMap(idRefProvider -> idRefProvider.getIdentityReferenceType(declaredType, context)).isPresent();
    }

    public List<ResolvedType> findSubtypes(ResolvedType declaredType, SchemaGenerationContext context) {
        if (this.skipSubtypeResolution(declaredType, context.getTypeContext())) {
            return null;
        }
        TypeContext typeContext = context.getTypeContext();
        ResolvedType typeWithTypeInfo = typeContext.getTypeWithAnnotation(declaredType, JsonTypeInfo.class, ReflectiveJacksonSchemaModule.NESTED_ANNOTATION_CHECK);
        if (!declaredType.equals((Object)typeWithTypeInfo)) {
            return null;
        }
        AnnotatedClass annotatedClass = AnnotatedClassResolver.resolveWithoutSuperTypes((MapperConfig)this.objectMapper.getDeserializationConfig(), (Class)declaredType.getErasedType());
        Collection registeredSubtypes = this.objectMapper.getSubtypeResolver().collectAndResolveSubtypesByTypeId((MapperConfig)this.objectMapper.getDeserializationConfig(), annotatedClass);
        return registeredSubtypes.stream().map(NamedType::getType).map(x$0 -> typeContext.resolve(x$0, new Type[0])).filter(resolvedType -> !resolvedType.equals((Object)declaredType)).filter(resolvedType -> !resolvedType.getErasedType().isInterface() && !Modifier.isAbstract(resolvedType.getErasedType().getModifiers())).filter(resolvedType -> this.filterSubtypesWithMatchingTypeBindings(declaredType, (ResolvedType)resolvedType)).sorted(Comparator.comparing(a -> a.getErasedType().getName())).collect(Collectors.toList());
    }

    public boolean filterSubtypesWithMatchingTypeBindings(ResolvedType declaredType, ResolvedType resolvedType) {
        List resolvedTypeParameters = resolvedType.typeParametersFor(declaredType.getErasedType());
        if (resolvedTypeParameters == null) {
            return false;
        }
        return declaredType.getTypeBindings().isEmpty() || resolvedTypeParameters.equals(declaredType.getTypeBindings().getTypeParameters());
    }

    public CustomDefinition provideCustomSchemaDefinition(ResolvedType javaType, SchemaGenerationContext context) {
        if (javaType == null) {
            return null;
        }
        TypeContext typeContext = context.getTypeContext();
        ResolvedType typeWithTypeInfo = typeContext.getTypeWithAnnotation(javaType, JsonTypeInfo.class, ReflectiveJacksonSchemaModule.NESTED_ANNOTATION_CHECK);
        if (typeWithTypeInfo == null || javaType.equals((Object)typeWithTypeInfo) || this.skipSubtypeResolution(javaType, typeContext)) {
            return null;
        }
        Class erasedTypeWithTypeInfo = typeWithTypeInfo.getErasedType();
        List<Annotation> annotationsList = Arrays.asList(erasedTypeWithTypeInfo.getAnnotations());
        JsonTypeInfo typeInfoAnnotation = (JsonTypeInfo)typeContext.getAnnotationFromList(JsonTypeInfo.class, annotationsList, ReflectiveJacksonSchemaModule.NESTED_ANNOTATION_CHECK);
        TypeScope scope = typeContext.createTypeScope(javaType);
        ObjectNode definition = this.createSubtypeDefinition(scope, typeInfoAnnotation, context);
        if (definition == null) {
            return null;
        }
        return new CustomDefinition(definition, this.wrappingSubtypeDefinitionType, CustomDefinition.AttributeInclusion.NO);
    }

    private String getTypeIdentifier(ResolvedType javaType, JsonTypeInfo typeInfoAnnotation) {
        Class erasedTargetType = javaType.getErasedType();
        return switch (typeInfoAnnotation.use()) {
            case JsonTypeInfo.Id.NAME -> throw new NotImplementedException("Lookup of JsonTypeInfo.Id.NAME from object mapper is not yet supported");
            case JsonTypeInfo.Id.SIMPLE_NAME -> erasedTargetType.getSimpleName();
            case JsonTypeInfo.Id.CLASS -> erasedTargetType.getName();
            default -> null;
        };
    }

    private ObjectNode createSubtypeDefinition(TypeScope scope, JsonTypeInfo typeInfoAnnotation, SchemaGenerationContext context) {
        ResolvedType javaType = scope.getType();
        String typeIdentifier = this.getTypeIdentifier(javaType, typeInfoAnnotation);
        if (typeIdentifier == null) {
            return null;
        }
        ObjectNode attributesToInclude = this.getAttributesToInclude(scope, context);
        ObjectNode definition = context.getGeneratorConfig().createObjectNode();
        SubtypeDefinitionDetails subtypeDetails = new SubtypeDefinitionDetails(javaType, attributesToInclude, context, typeIdentifier, definition);
        switch (typeInfoAnnotation.include()) {
            case WRAPPER_ARRAY: {
                this.createSubtypeDefinitionForWrapperArrayTypeInfo(subtypeDetails);
                break;
            }
            case WRAPPER_OBJECT: {
                this.createSubtypeDefinitionForWrapperObjectTypeInfo(subtypeDetails);
                break;
            }
            case PROPERTY: 
            case EXISTING_PROPERTY: {
                this.createSubtypeDefinitionForPropertyTypeInfo(subtypeDetails, typeInfoAnnotation);
                break;
            }
            default: {
                return null;
            }
        }
        return definition;
    }

    private void createSubtypeDefinitionForWrapperArrayTypeInfo(SubtypeDefinitionDetails details) {
        details.getDefinition().put(details.getKeyword(SchemaKeyword.TAG_TYPE), details.getKeyword(SchemaKeyword.TAG_TYPE_ARRAY));
        ArrayNode itemsArray = details.getDefinition().withArray(details.getKeyword(SchemaKeyword.TAG_PREFIX_ITEMS));
        itemsArray.addObject().put(details.getKeyword(SchemaKeyword.TAG_TYPE), details.getKeyword(SchemaKeyword.TAG_TYPE_STRING)).put(details.getKeyword(SchemaKeyword.TAG_CONST), details.getTypeIdentifier());
        if (details.getAttributesToInclude() == null || details.getAttributesToInclude().isEmpty()) {
            itemsArray.add((JsonNode)this.createNestedSubtypeSchema(details.getJavaType(), details.getContext()));
        } else {
            itemsArray.addObject().withArray(details.getKeyword(SchemaKeyword.TAG_ALLOF)).add((JsonNode)this.createNestedSubtypeSchema(details.getJavaType(), details.getContext())).add((JsonNode)details.getAttributesToInclude());
        }
    }

    private void createSubtypeDefinitionForWrapperObjectTypeInfo(SubtypeDefinitionDetails details) {
        details.getDefinition().put(details.getKeyword(SchemaKeyword.TAG_TYPE), details.getKeyword(SchemaKeyword.TAG_TYPE_OBJECT));
        ObjectNode propertiesNode = details.getDefinition().putObject(details.getKeyword(SchemaKeyword.TAG_PROPERTIES));
        ObjectNode nestedSubtypeSchema = this.createNestedSubtypeSchema(details.getJavaType(), details.getContext());
        if (details.getAttributesToInclude() == null || details.getAttributesToInclude().isEmpty()) {
            propertiesNode.set(details.getTypeIdentifier(), (JsonNode)nestedSubtypeSchema);
        } else {
            propertiesNode.putObject(details.getTypeIdentifier()).withArray(details.getKeyword(SchemaKeyword.TAG_ALLOF)).add((JsonNode)nestedSubtypeSchema).add((JsonNode)details.getAttributesToInclude());
        }
        details.getDefinition().withArray(details.getKeyword(SchemaKeyword.TAG_REQUIRED)).add(details.getTypeIdentifier());
    }

    private void createSubtypeDefinitionForPropertyTypeInfo(SubtypeDefinitionDetails details, JsonTypeInfo typeInfoAnnotation) {
        String propertyName = Optional.ofNullable(typeInfoAnnotation.property()).filter(name -> !name.isEmpty()).orElseGet(() -> typeInfoAnnotation.use().getDefaultPropertyName());
        ObjectNode additionalPart = details.getDefinition().withArray(details.getKeyword(SchemaKeyword.TAG_ALLOF)).add((JsonNode)this.createNestedSubtypeSchema(details.getJavaType(), details.getContext())).addObject();
        if (details.getAttributesToInclude() != null && !details.getAttributesToInclude().isEmpty()) {
            additionalPart.setAll(details.getAttributesToInclude());
        }
        additionalPart.put(details.getKeyword(SchemaKeyword.TAG_TYPE), details.getKeyword(SchemaKeyword.TAG_TYPE_OBJECT)).putObject(details.getKeyword(SchemaKeyword.TAG_PROPERTIES)).putObject(propertyName).put(details.getKeyword(SchemaKeyword.TAG_CONST), details.getTypeIdentifier());
        if (!details.getJavaType().getErasedType().equals(typeInfoAnnotation.defaultImpl())) {
            additionalPart.withArray(details.getKeyword(SchemaKeyword.TAG_REQUIRED)).add(propertyName);
        }
    }

    private ObjectNode createNestedSubtypeSchema(ResolvedType javaType, SchemaGenerationContext context) {
        if (this.shouldInlineNestedSubtypes) {
            return context.createStandardDefinition(javaType, (CustomDefinitionProviderV2)this);
        }
        return context.createStandardDefinitionReference(javaType, (CustomDefinitionProviderV2)this);
    }

    private ObjectNode getAttributesToInclude(TypeScope scope, SchemaGenerationContext context) {
        Object attributesToInclude = scope instanceof FieldScope ? AttributeCollector.collectFieldAttributes((FieldScope)((FieldScope)scope), (SchemaGenerationContext)context) : (scope instanceof MethodScope ? AttributeCollector.collectMethodAttributes((MethodScope)((MethodScope)scope), (SchemaGenerationContext)context) : null);
        return attributesToInclude;
    }

    private static class SubtypeDefinitionDetails {
        private final ResolvedType javaType;
        private final ObjectNode attributesToInclude;
        private final SchemaGenerationContext context;
        private final String typeIdentifier;
        private final ObjectNode definition;

        SubtypeDefinitionDetails(ResolvedType javaType, ObjectNode attributesToInclude, SchemaGenerationContext context, String typeIdentifier, ObjectNode definition) {
            this.javaType = javaType;
            this.attributesToInclude = attributesToInclude;
            this.context = context;
            this.typeIdentifier = typeIdentifier;
            this.definition = definition;
        }

        ResolvedType getJavaType() {
            return this.javaType;
        }

        ObjectNode getAttributesToInclude() {
            return this.attributesToInclude;
        }

        SchemaGenerationContext getContext() {
            return this.context;
        }

        String getTypeIdentifier() {
            return this.typeIdentifier;
        }

        ObjectNode getDefinition() {
            return this.definition;
        }

        String getKeyword(SchemaKeyword keyword) {
            return this.context.getKeyword(keyword);
        }
    }
}

