/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.length;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ModifiableLengthField
extends ModifiableInteger {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(required=true)
    private final ModifiableByteArray ref;

    private ModifiableLengthField() {
        this.ref = null;
    }

    public ModifiableLengthField(ModifiableByteArray ref) {
        this.ref = Objects.requireNonNull(ref);
    }

    public ModifiableLengthField(ModifiableLengthField other) {
        super(other);
        this.ref = other.ref;
    }

    @Override
    public ModifiableLengthField createCopy() {
        return new ModifiableLengthField(this);
    }

    @Override
    public Integer getOriginalValue() {
        if (this.ref.getValue() == null) {
            return null;
        }
        return ((byte[])this.ref.getValue()).length;
    }

    @Override
    public void setOriginalValue(Integer originalValue) {
        throw new UnsupportedOperationException("Cannot set original Value of ModifiableLengthField");
    }

    @Override
    public String toString() {
        return "ModifiableLengthField{ref=" + String.valueOf(this.ref) + super.toString() + "} ";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModifiableLengthField)) {
            return false;
        }
        ModifiableLengthField that = (ModifiableLengthField)obj;
        boolean valuesEqual = this.getValue() == null ? that.getValue() == null : ((Integer)this.getValue()).equals(that.getValue());
        boolean refsEqual = this.ref.equals(that.ref);
        return valuesEqual && refsEqual;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.getValue() != null ? ((Integer)this.getValue()).hashCode() : 0);
        result = 31 * result + this.ref.hashCode();
        return result;
    }
}

