/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.longint;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.modifiablevariable.util.DataConverter;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ModifiableLong
extends ModifiableVariable<Long> {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Long originalValue;

    public ModifiableLong() {
    }

    public ModifiableLong(Long originalValue) {
        this.originalValue = originalValue;
    }

    public ModifiableLong(ModifiableLong other) {
        super(other);
        this.originalValue = other.originalValue;
    }

    public ModifiableLong createCopy() {
        return new ModifiableLong(this);
    }

    public Long getAssertEquals() {
        return (Long)this.assertEquals;
    }

    public void setAssertEquals(Long assertEquals) {
        this.assertEquals = assertEquals;
    }

    @Override
    public boolean isOriginalValueModified() {
        if (this.originalValue == null) {
            throw new IllegalStateException("Original value must be set before checking for modifications");
        }
        return !this.originalValue.equals(this.getValue());
    }

    public byte[] getByteArray(int size) {
        return DataConverter.longToBytes((Long)this.getValue(), size);
    }

    @Override
    public boolean validateAssertions() {
        boolean valid = true;
        if (this.assertEquals != null && ((Long)this.assertEquals).compareTo((Long)this.getValue()) != 0) {
            valid = false;
        }
        return valid;
    }

    @Override
    public Long getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public void setOriginalValue(Long originalValue) {
        this.originalValue = originalValue;
    }

    public String toString() {
        return "ModifiableLong{originalValue=" + this.originalValue + this.innerToString() + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModifiableLong)) {
            return false;
        }
        ModifiableLong that = (ModifiableLong)obj;
        return this.getValue() != null ? ((Long)this.getValue()).equals(that.getValue()) : that.getValue() == null;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.getValue() != null ? ((Long)this.getValue()).hashCode() : 0);
        return result;
    }
}

