/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.singlebyte;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;

@XmlRootElement
public class ByteAddModification
extends VariableModification<Byte> {
    @JsonProperty(required=true)
    private byte summand;

    private ByteAddModification() {
    }

    public ByteAddModification(byte summand) {
        this.summand = summand;
    }

    public ByteAddModification(ByteAddModification other) {
        this.summand = other.summand;
    }

    public ByteAddModification createCopy() {
        return new ByteAddModification(this);
    }

    @Override
    protected Byte modifyImplementationHook(Byte input) {
        if (input == null) {
            return null;
        }
        return (byte)(input + this.summand);
    }

    public byte getSummand() {
        return this.summand;
    }

    public void setSummand(byte summand) {
        this.summand = summand;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.summand;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteAddModification other = (ByteAddModification)obj;
        return Objects.equals(this.summand, other.summand);
    }

    public String toString() {
        return "ByteAddModification{summand=" + this.summand + "}";
    }
}

