/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.string;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.modifiablevariable.util.IllegalStringAdapter;
import de.rub.nds.modifiablevariable.util.StringUtil;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.nio.charset.StandardCharsets;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class ModifiableString
extends ModifiableVariable<String> {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String originalValue;

    public ModifiableString() {
    }

    public ModifiableString(String originalValue) {
        this.originalValue = originalValue;
    }

    public ModifiableString(ModifiableString other) {
        super(other);
        this.originalValue = other.originalValue;
    }

    public ModifiableString createCopy() {
        return new ModifiableString(this);
    }

    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    public String getAssertEquals() {
        return (String)this.assertEquals;
    }

    public void setAssertEquals(String assertEquals) {
        this.assertEquals = assertEquals;
    }

    @Override
    public boolean isOriginalValueModified() {
        return this.originalValue != null && this.originalValue.compareTo((String)this.getValue()) != 0;
    }

    public byte[] getByteArray() {
        return ((String)this.getValue()).getBytes(StandardCharsets.ISO_8859_1);
    }

    @Override
    public boolean validateAssertions() {
        boolean valid = true;
        if (this.assertEquals != null && ((String)this.assertEquals).compareTo((String)this.getValue()) != 0) {
            valid = false;
        }
        return valid;
    }

    @Override
    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    public String getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public void setOriginalValue(String originalValue) {
        this.originalValue = originalValue;
    }

    public String toString() {
        return "ModifiableString{originalValue='" + StringUtil.backslashEscapeString(this.originalValue) + "'" + this.innerToString() + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModifiableString)) {
            return false;
        }
        ModifiableString that = (ModifiableString)obj;
        return this.getValue() != null ? ((String)this.getValue()).equals(that.getValue()) : that.getValue() == null;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.getValue() != null ? ((String)this.getValue()).hashCode() : 0);
        return result;
    }
}

