/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.string;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.IllegalStringAdapter;
import de.rub.nds.modifiablevariable.util.StringUtil;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Objects;

@XmlRootElement
public class StringAppendValueModification
extends VariableModification<String> {
    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    @JsonProperty(required=true)
    private String appendValue;

    private StringAppendValueModification() {
    }

    public StringAppendValueModification(String appendValue) {
        this.appendValue = Objects.requireNonNull(appendValue, "AppendValue must not be null");
    }

    public StringAppendValueModification(StringAppendValueModification other) {
        this.appendValue = other.appendValue;
    }

    public StringAppendValueModification createCopy() {
        return new StringAppendValueModification(this);
    }

    @Override
    protected String modifyImplementationHook(String input) {
        if (input == null) {
            return null;
        }
        return input + this.appendValue;
    }

    public String getAppendValue() {
        return this.appendValue;
    }

    public void setAppendValue(String appendValue) {
        this.appendValue = Objects.requireNonNull(appendValue, "AppendValue must not be null");
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.appendValue);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringAppendValueModification other = (StringAppendValueModification)obj;
        return Objects.equals(this.appendValue, other.appendValue);
    }

    public String toString() {
        return "StringAppendValueModification{appendValue='" + StringUtil.backslashEscapeString(this.appendValue) + "'}";
    }
}

