/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.string;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.IllegalStringAdapter;
import de.rub.nds.modifiablevariable.util.StringUtil;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Objects;

@XmlRootElement
public class StringExplicitValueModification
extends VariableModification<String> {
    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    @JsonProperty(required=true)
    private String explicitValue;

    private StringExplicitValueModification() {
    }

    public StringExplicitValueModification(String explicitValue) {
        this.explicitValue = Objects.requireNonNull(explicitValue, "ExplicitValue must not be null");
    }

    public StringExplicitValueModification(StringExplicitValueModification other) {
        this.explicitValue = other.explicitValue;
    }

    public StringExplicitValueModification createCopy() {
        return new StringExplicitValueModification(this);
    }

    @Override
    protected String modifyImplementationHook(String input) {
        if (input == null) {
            return null;
        }
        return this.explicitValue;
    }

    public String getExplicitValue() {
        return this.explicitValue;
    }

    public void setExplicitValue(String explicitValue) {
        this.explicitValue = Objects.requireNonNull(explicitValue, "ExplicitValue must not be null");
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.explicitValue);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringExplicitValueModification other = (StringExplicitValueModification)obj;
        return Objects.equals(this.explicitValue, other.explicitValue);
    }

    public String toString() {
        return "StringExplicitValueModification{explicitValue='" + StringUtil.backslashEscapeString(this.explicitValue) + "'}";
    }
}

