/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.string;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.IllegalStringAdapter;
import de.rub.nds.modifiablevariable.util.StringUtil;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Objects;

@XmlRootElement
public class StringInsertValueModification
extends VariableModification<String> {
    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    @JsonProperty(required=true)
    private String insertValue;
    @JsonProperty(required=true)
    private int startPosition;

    private StringInsertValueModification() {
    }

    public StringInsertValueModification(String insertValue, int startPosition) {
        this.insertValue = Objects.requireNonNull(insertValue, "InsertValue must not be null");
        this.startPosition = startPosition;
    }

    public StringInsertValueModification(StringInsertValueModification other) {
        this.insertValue = other.insertValue;
        this.startPosition = other.startPosition;
    }

    public StringInsertValueModification createCopy() {
        return new StringInsertValueModification(this);
    }

    @Override
    protected String modifyImplementationHook(String input) {
        if (input == null) {
            return null;
        }
        if (input.isEmpty()) {
            return this.insertValue;
        }
        int insertPosition = this.startPosition < 0 ? Math.max(0, input.length() + this.startPosition) : (this.startPosition >= input.length() ? input.length() : this.startPosition);
        return new StringBuilder(input).insert(insertPosition, this.insertValue).toString();
    }

    public String getInsertValue() {
        return this.insertValue;
    }

    public void setInsertValue(String insertValue) {
        this.insertValue = Objects.requireNonNull(insertValue, "InsertValue must not be null");
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.insertValue);
        hash = 31 * hash + this.startPosition;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringInsertValueModification other = (StringInsertValueModification)obj;
        if (this.startPosition != other.startPosition) {
            return false;
        }
        return Objects.equals(this.insertValue, other.insertValue);
    }

    public String toString() {
        return "StringInsertValueModification{insertValue='" + StringUtil.backslashEscapeString(this.insertValue) + "', startPosition=" + this.startPosition + "}";
    }
}

