/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.util;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.util.ModifiableVariableField;
import de.rub.nds.modifiablevariable.util.ModifiableVariableListHolder;
import de.rub.nds.modifiablevariable.util.RandomHelper;
import de.rub.nds.modifiablevariable.util.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModifiableVariableAnalyzer {
    private static final Logger LOGGER = LogManager.getLogger();

    private ModifiableVariableAnalyzer() {
    }

    public static List<Field> getAllModifiableVariableFields(Object object) {
        return ReflectionHelper.getFieldsUpTo(object.getClass(), null, ModifiableVariable.class);
    }

    public static Field getRandomModifiableVariableField(Object object) {
        List<Field> fields = ModifiableVariableAnalyzer.getAllModifiableVariableFields(object);
        if (fields.isEmpty()) {
            return null;
        }
        int randomField = RandomHelper.getRandom().nextInt(fields.size());
        return fields.get(randomField);
    }

    public static boolean isModifiableVariableHolder(Object object) {
        List<Field> fields = ModifiableVariableAnalyzer.getAllModifiableVariableFields(object);
        return !fields.isEmpty();
    }

    public static List<ModifiableVariableField> getAllModifiableVariableFieldsRecursively(Object object) {
        List<ModifiableVariableListHolder> holders = ModifiableVariableAnalyzer.getAllModifiableVariableHoldersRecursively(object);
        LinkedList<ModifiableVariableField> fields = new LinkedList<ModifiableVariableField>();
        for (ModifiableVariableListHolder holder : holders) {
            for (Field field : holder.getFields()) {
                fields.add(new ModifiableVariableField(holder.getObject(), field));
            }
        }
        return fields;
    }

    public static List<ModifiableVariableListHolder> getAllModifiableVariableHoldersRecursively(Object object) {
        LinkedList<ModifiableVariableListHolder> holders = new LinkedList<ModifiableVariableListHolder>();
        List<Field> modFields = ModifiableVariableAnalyzer.getAllModifiableVariableFields(object);
        if (!modFields.isEmpty()) {
            holders.add(new ModifiableVariableListHolder(object, modFields));
        }
        List<Field> allFields = ReflectionHelper.getFieldsUpTo(object.getClass(), null, null);
        for (Field field : allFields) {
            try {
                HoldsModifiableVariable holdsVariable = field.getAnnotation(HoldsModifiableVariable.class);
                field.setAccessible(true);
                Object possibleHolder = field.get(object);
                if (possibleHolder == null || holdsVariable == null) continue;
                if (possibleHolder instanceof List) {
                    List castedList = (List)possibleHolder;
                    holders.addAll(ModifiableVariableAnalyzer.getAllModifiableVariableHoldersFromList(castedList));
                    continue;
                }
                if (possibleHolder.getClass().isArray()) {
                    holders.addAll(ModifiableVariableAnalyzer.getAllModifiableVariableHoldersFromArray((Object[])possibleHolder));
                    continue;
                }
                holders.addAll(ModifiableVariableAnalyzer.getAllModifiableVariableHoldersRecursively(possibleHolder));
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                LOGGER.warn("Accessing field {} of type {} not possible: {}", (Object)field.getName(), field.getType(), (Object)ex.toString());
            }
        }
        return holders;
    }

    public static List<ModifiableVariableListHolder> getAllModifiableVariableHoldersFromList(List<Object> list) {
        LinkedList<ModifiableVariableListHolder> result = new LinkedList<ModifiableVariableListHolder>();
        for (Object o : list) {
            if (o != null) {
                result.addAll(ModifiableVariableAnalyzer.getAllModifiableVariableHoldersRecursively(o));
                continue;
            }
            LOGGER.warn("Found null getAllModifiableVariableHoldersFromList");
        }
        return result;
    }

    public static List<ModifiableVariableListHolder> getAllModifiableVariableHoldersFromArray(Object[] array) {
        LinkedList<ModifiableVariableListHolder> result = new LinkedList<ModifiableVariableListHolder>();
        for (Object o : array) {
            result.addAll(ModifiableVariableAnalyzer.getAllModifiableVariableHoldersRecursively(o));
        }
        return result;
    }

    public static List<Field> getAnnotatedFields(Class<?> clazz) {
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        for (Class<?> currentClass = clazz; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(ModifiableVariableProperty.class)) continue;
                annotatedFields.add(field);
            }
        }
        return annotatedFields;
    }

    public static Map<ModifiableVariableProperty.Purpose, List<Field>> groupFieldsByPurpose(Class<?> clazz) {
        return ModifiableVariableAnalyzer.getAnnotatedFields(clazz).stream().collect(Collectors.groupingBy(field -> field.getAnnotation(ModifiableVariableProperty.class).purpose()));
    }

    public static Map<ModifiableVariableProperty.Encoding, List<Field>> groupFieldsByEncoding(Class<?> clazz) {
        return ModifiableVariableAnalyzer.getAnnotatedFields(clazz).stream().collect(Collectors.groupingBy(field -> field.getAnnotation(ModifiableVariableProperty.class).encoding()));
    }

    public static List<Field> getFieldsByPurpose(Class<?> clazz, ModifiableVariableProperty.Purpose purpose) {
        return ModifiableVariableAnalyzer.getAnnotatedFields(clazz).stream().filter(field -> field.getAnnotation(ModifiableVariableProperty.class).purpose() == purpose).collect(Collectors.toList());
    }

    public static List<Field> getFieldsByEncoding(Class<?> clazz, ModifiableVariableProperty.Encoding encoding) {
        return ModifiableVariableAnalyzer.getAnnotatedFields(clazz).stream().filter(field -> field.getAnnotation(ModifiableVariableProperty.class).encoding() == encoding).collect(Collectors.toList());
    }

    public static boolean isAnnotated(Field field) {
        return field.isAnnotationPresent(ModifiableVariableProperty.class);
    }

    public static ModifiableVariableProperty getAnnotation(Field field) {
        return field.getAnnotation(ModifiableVariableProperty.class);
    }

    public static List<String> getUnannotatedModifiableVariables(Class<?> clazz) {
        List<Field> allModifiableFields = ReflectionHelper.getFieldsUpTo(clazz, null, ModifiableVariable.class);
        return allModifiableFields.stream().filter(field -> !ModifiableVariableAnalyzer.isAnnotated(field)).map(Field::getName).collect(Collectors.toList());
    }
}

