/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.util;

import de.rub.nds.modifiablevariable.util.BadRandom;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Random;

public final class RandomHelper {
    private static Random random;

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"}, justification="Intentionally exposing mutable static Random for testing flexibility. This class is designed for test environments where controlled randomness is required, and the ability to modify or replace the Random instance is a feature, not a bug.")
    public static synchronized Random getRandom() {
        if (random == null) {
            random = new Random(0L);
        }
        return random;
    }

    public static BadRandom getBadSecureRandom() {
        return new BadRandom(RandomHelper.getRandom());
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_STATIC_REP2"}, justification="Intentionally allowing external Random instances to be set for testing flexibility. This class is designed for test environments where controlled randomness is required, and the ability to replace the Random instance is a feature, not a bug.")
    public static synchronized void setRandom(Random randomInstance) {
        random = randomInstance;
    }

    private RandomHelper() {
    }
}

