/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.util;

public final class StringUtil {
    private StringUtil() {
    }

    public static String backslashEscapeString(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(value);
        block8: for (int i = 0; i < builder.length(); ++i) {
            String replacement;
            int codePoint = builder.codePointAt(i);
            int numCodePoints = 1;
            switch (codePoint) {
                case 13: {
                    replacement = "\\r";
                    break;
                }
                case 10: {
                    replacement = "\\n";
                    break;
                }
                case 9: {
                    replacement = "\\t";
                    break;
                }
                case 12: {
                    replacement = "\\f";
                    break;
                }
                case 8: {
                    replacement = "\\b";
                    break;
                }
                case 92: {
                    replacement = "\\\\";
                    break;
                }
                default: {
                    if (Character.isSupplementaryCodePoint(codePoint)) {
                        replacement = String.format("\\u%04X\\u%04X", Character.highSurrogate(codePoint), (int)Character.lowSurrogate(codePoint));
                        numCodePoints = 2;
                        break;
                    }
                    if (codePoint >= 32 && codePoint <= 127) continue block8;
                    replacement = codePoint > 0x10FFFF ? "\\uFFFD" : String.format("\\u%04X", codePoint);
                }
            }
            builder.replace(i, i + numCodePoints, replacement);
            i += replacement.length() - 1;
        }
        return builder.toString();
    }
}

