/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.proxy;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.socket.TlsAttackerSslSocket;
import de.rub.nds.tlsattacker.proxy.ProxyConfig;
import java.io.InputStream;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProxyConnection
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Socket incomingSocket;
    private boolean initialized = false;
    private final Config config;
    private final ProxyConfig proxyConfig;

    public ProxyConnection(ProxyConfig proxyConfig, Config config, Socket socket) {
        this.incomingSocket = socket;
        this.proxyConfig = proxyConfig;
        this.config = config;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    @Override
    public void run() {
        while (!this.incomingSocket.isClosed()) {
            try {
                if (this.incomingSocket.getInputStream().available() > 0) {
                    if (this.initialized) continue;
                    InputStream inputStream = this.incomingSocket.getInputStream();
                    if (inputStream.read() != 5) {
                        throw new Exception("Connection is not Socks5 - only socks5 supported");
                    }
                    int length = inputStream.read();
                    for (int i = 0; i < length; ++i) {
                        LOGGER.debug("Reading authentication method");
                        inputStream.read();
                    }
                    this.incomingSocket.getOutputStream().write(new byte[]{5, 0});
                    this.incomingSocket.getOutputStream().flush();
                    String line = "";
                    LOGGER.info("Received: {}", (Object)line);
                    String[] parsed = line.split(" ");
                    if (parsed.length >= 3) {
                        String method = parsed[0];
                        String destinationhostport = parsed[1];
                        String protocol = parsed[2];
                        if (method.equals("CONNECT")) {
                            String hostname = destinationhostport.split(":")[0];
                            int port = Integer.parseInt(destinationhostport.split(":")[1]);
                            TlsAttackerSslSocket tlsAttackerSslSocket = new TlsAttackerSslSocket(this.config, hostname, port, (long)this.config.getDefaultClientConnection().getTimeout().intValue());
                        }
                    }
                    this.initialized = true;
                    continue;
                }
                Thread.currentThread();
                Thread.sleep(50L);
            }
            catch (Exception e) {
                LOGGER.debug("Error in proxy connection loop", (Throwable)e);
            }
        }
    }
}

