/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.constants;

import de.rub.nds.protocol.constants.GroupParameters;
import de.rub.nds.protocol.crypto.CyclicGroup;
import de.rub.nds.protocol.crypto.ffdh.FfdhGroup;
import java.math.BigInteger;

public abstract class FfdhGroupParameters
implements GroupParameters<BigInteger> {
    private final BigInteger generator;
    private final BigInteger modulus;

    public FfdhGroupParameters(BigInteger generator, BigInteger modulus) {
        this.generator = generator;
        this.modulus = modulus;
    }

    public BigInteger getGenerator() {
        return this.generator;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public int getElementSizeBits() {
        return this.modulus.bitLength();
    }

    @Override
    public int getElementSizeBytes() {
        return (int)Math.ceil((double)this.getElementSizeBits() / 8.0);
    }

    @Override
    public CyclicGroup<BigInteger> getGroup() {
        return new FfdhGroup(this);
    }
}

