/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.constants;

public enum MacAlgorithm {
    NONE(0, 0, null),
    SSLMAC_MD5(16, 16, "SslMacMD5"),
    SSLMAC_SHA1(20, 20, "SslMacSHA1"),
    HMAC_MD5(16, 16, "HmacMD5"),
    HMAC_SHA1(20, 20, "HmacSHA1"),
    HMAC_SHA256(32, 32, "HmacSHA256"),
    HMAC_SHA384(48, 48, "HmacSHA384"),
    HMAC_SHA512(64, 64, "HmacSHA512"),
    HMAC_SHA512_224(28, 28, "HmacSHA512/224"),
    HMAC_SHA512_256(32, 32, "HmacSHA512/256"),
    IMIT_GOST28147(4, 32, "GOST28147MAC"),
    HMAC_GOSTR3411(32, 32, "HmacGOST3411"),
    HMAC_GOSTR3411_2012_256(32, 32, "HmacGOST3411-2012-256"),
    HMAC_SM3(32, 32, "HmacSM3");

    private int macLength;
    private int keySize;
    private String javaName;

    private MacAlgorithm(int macLength, int keySize, String javaName) {
        this.macLength = macLength;
        this.keySize = keySize;
        this.javaName = javaName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public int getMacLength() {
        return this.macLength;
    }

    public int getKeySize() {
        return this.keySize;
    }
}

