/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.crypto.dsa;

import de.rub.nds.protocol.constants.DsaParameters;
import de.rub.nds.protocol.crypto.CyclicGroup;
import java.math.BigInteger;

public class DsaGroup
implements CyclicGroup<BigInteger> {
    private final DsaParameters parameters;

    public DsaGroup(DsaParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public BigInteger groupOperation(BigInteger a, BigInteger b) {
        return a.multiply(b).mod(this.parameters.getP());
    }

    @Override
    public BigInteger nTimesGroupOperation(BigInteger a, BigInteger scalar) {
        return a.modPow(scalar, this.parameters.getP());
    }

    @Override
    public BigInteger getGenerator() {
        return this.parameters.getG();
    }

    @Override
    public BigInteger nTimesGroupOperationOnGenerator(BigInteger scalar) {
        return this.nTimesGroupOperation(this.parameters.getG(), scalar);
    }

    public BigInteger getP() {
        return this.parameters.getP();
    }

    public BigInteger getQ() {
        return this.parameters.getQ();
    }

    public DsaParameters getParameters() {
        return this.parameters;
    }
}

