/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.crypto.ec;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.protocol.crypto.ec.RFC7748Curve;
import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;

public class EllipticCurve448
extends RFC7748Curve {
    public EllipticCurve448() {
        super(new BigInteger("262A6", 16), new BigInteger("1", 16), new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", 16), new BigInteger("5", 16), new BigInteger("7D235D1295F5B1F66C98AB6E58326FCECBAE5D34F55545D060F75DC28DF3F6EDB8027E2346430D211312C4B150677AF76FD7223D457B5B1A", 16), new BigInteger("3FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7CCA23E9C44EDB49AED63690216CC2728DC58F552378C292AB5844F3", 16));
    }

    @Override
    public BigInteger decodeScalar(BigInteger scalar) {
        byte[] scalarA = ArrayConverter.bigIntegerToByteArray((BigInteger)scalar, (int)ArrayConverter.bigIntegerToByteArray((BigInteger)this.getModulus()).length, (boolean)true);
        scalarA[0] = (byte)(scalarA[0] & 0xFC);
        scalarA[55] = (byte)(scalarA[55] | 0x80);
        ArrayUtils.reverse((byte[])scalarA);
        return new BigInteger(1, scalarA);
    }

    @Override
    public BigInteger decodeCoordinate(BigInteger encCoordinate) {
        byte[] coordinate = ArrayConverter.bigIntegerToByteArray((BigInteger)encCoordinate, (int)ArrayConverter.bigIntegerToByteArray((BigInteger)this.getModulus()).length, (boolean)true);
        ArrayUtils.reverse((byte[])coordinate);
        return new BigInteger(1, coordinate).mod(this.getModulus());
    }

    @Override
    public byte[] encodeCoordinate(BigInteger coordinate) {
        byte[] encX = ArrayConverter.bigIntegerToByteArray((BigInteger)coordinate, (int)ArrayConverter.bigIntegerToByteArray((BigInteger)this.getModulus()).length, (boolean)true);
        ArrayUtils.reverse((byte[])encX);
        return encX;
    }
}

