/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.crypto.ec;

import de.rub.nds.protocol.crypto.ec.FieldElement;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FieldElementF2m
extends FieldElement {
    private static final Logger LOGGER = LogManager.getLogger();

    public FieldElementF2m(BigInteger data, BigInteger modulus) {
        super(data, modulus);
    }

    private FieldElementF2m() {
        super(null, null);
    }

    @Override
    public FieldElement add(FieldElement f) {
        BigInteger tmp = this.getData().xor(f.getData());
        return new FieldElementF2m(tmp, this.getModulus());
    }

    @Override
    public FieldElement mult(FieldElement f) {
        BigInteger thisData = this.getData();
        BigInteger fieldData = f.getData();
        BigInteger tmp = new BigInteger("0");
        int i = 0;
        while (i < fieldData.bitLength()) {
            if (fieldData.testBit(i)) {
                tmp = tmp.xor(thisData.shiftLeft(i));
            }
            ++i;
        }
        tmp = this.reduce(tmp);
        return new FieldElementF2m(tmp, this.getModulus());
    }

    @Override
    public FieldElement addInv() {
        return this;
    }

    @Override
    public FieldElement multInv() {
        BigInteger r;
        if (this.getData().equals(BigInteger.ZERO)) {
            throw new ArithmeticException();
        }
        if (this.getData().equals(BigInteger.ONE)) {
            return this;
        }
        BigInteger r2 = this.getModulus();
        BigInteger r1 = this.getData();
        BigInteger t2 = new BigInteger("0");
        BigInteger t1 = BigInteger.ONE;
        do {
            BigInteger[] division = this.polynomialDivision(r2, r1);
            r = division[1];
            BigInteger q = division[0];
            FieldElementF2m pointT1Polynomial = new FieldElementF2m(t1, this.getModulus());
            FieldElementF2m pointQPolynomial = new FieldElementF2m(q, this.getModulus());
            BigInteger t = pointT1Polynomial.mult(pointQPolynomial).getData();
            t = this.reduce(t);
            t = t2.xor(t);
            t2 = t1;
            t1 = t;
            r2 = r1;
        } while (!(r1 = r).equals(BigInteger.ONE) && !r1.equals(BigInteger.ZERO));
        return new FieldElementF2m(t1, this.getModulus());
    }

    private BigInteger[] polynomialDivision(BigInteger f, BigInteger p) {
        int modLength = p.bitLength();
        BigInteger q = new BigInteger("0");
        while (f.bitLength() >= modLength && modLength != 0) {
            BigInteger tmp = new BigInteger("1");
            tmp = tmp.shiftLeft(f.bitLength() - modLength);
            q = q.xor(tmp);
            BigInteger shift = p.multiply(tmp);
            f = f.xor(shift);
        }
        BigInteger[] result = new BigInteger[]{q, f};
        return result;
    }

    private BigInteger reduce(BigInteger f) {
        return this.polynomialDivision(f, this.getModulus())[1];
    }

    public FieldElementF2m squarePow(int exponent) {
        FieldElement square = this.mult(this);
        int i = 1;
        while (i < exponent) {
            square = square.mult(square);
            ++i;
        }
        return (FieldElementF2m)square;
    }
}

