/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.crypto.ec;

import de.rub.nds.protocol.constants.GroupParameters;
import de.rub.nds.protocol.crypto.CyclicGroup;
import de.rub.nds.protocol.crypto.ec.EllipticCurve;
import de.rub.nds.protocol.crypto.ec.FieldElement;
import de.rub.nds.protocol.crypto.ec.FieldElementF2m;
import de.rub.nds.protocol.crypto.ec.FieldElementFp;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Point
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlElements(value={@XmlElement(type=FieldElementF2m.class, name="xFieldElementF2m"), @XmlElement(type=FieldElementFp.class, name="xFieldElementFp")})
    private final FieldElement fieldX;
    @XmlElements(value={@XmlElement(type=FieldElementF2m.class, name="yFieldElementF2m"), @XmlElement(type=FieldElementFp.class, name="yFieldElementFp")})
    private final FieldElement fieldY;
    private final boolean infinity;

    public static Point createPoint(BigInteger x, BigInteger y, GroupParameters<?> curveParameters) {
        CyclicGroup<?> group = curveParameters.getGroup();
        if (!(group instanceof EllipticCurve)) {
            LOGGER.warn("Cannot create point for non-elliptic curve");
            return null;
        }
        EllipticCurve curve = (EllipticCurve)group;
        return curve.getPoint(x, y);
    }

    public Point() {
        this.infinity = true;
        this.fieldX = null;
        this.fieldY = null;
    }

    public Point(FieldElement x, FieldElement y) {
        this.fieldX = x;
        this.fieldY = y;
        this.infinity = false;
    }

    public boolean isAtInfinity() {
        return this.infinity;
    }

    public FieldElement getFieldX() {
        return this.fieldX;
    }

    public FieldElement getFieldY() {
        return this.fieldY;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.fieldX);
        hash = 89 * hash + Objects.hashCode(this.fieldY);
        hash = 89 * hash + (this.infinity ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        if (this.infinity != other.infinity) {
            return false;
        }
        if (!Objects.equals(this.fieldX, other.fieldX)) {
            return false;
        }
        return Objects.equals(this.fieldY, other.fieldY);
    }

    public String toString() {
        if (this.isAtInfinity()) {
            return "Point: Infinity";
        }
        return "Point: (" + this.getFieldX().toString() + ", " + this.getFieldY().toString() + ")";
    }
}

