/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.crypto.ec;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.protocol.constants.EcCurveEquationType;
import de.rub.nds.protocol.constants.GroupParameters;
import de.rub.nds.protocol.constants.NamedEllipticCurveParameters;
import de.rub.nds.protocol.constants.PointFormat;
import de.rub.nds.protocol.crypto.CyclicGroup;
import de.rub.nds.protocol.crypto.ec.EllipticCurve;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.crypto.ec.RFC7748Curve;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PointFormatter {
    private static final Logger LOGGER = LogManager.getLogger();

    public static byte[] formatToByteArray(GroupParameters<?> groupParameters, Point point, PointFormat format) {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        if (point.isAtInfinity()) {
            return new byte[1];
        }
        int elementLength = ArrayConverter.bigIntegerToByteArray((BigInteger)point.getFieldX().getModulus()).length;
        if (groupParameters instanceof NamedEllipticCurveParameters && ((NamedEllipticCurveParameters)groupParameters).getEquationType() == EcCurveEquationType.SHORT_WEIERSTRASS) {
            switch (format) {
                case UNCOMPRESSED: {
                    stream.write(4);
                    stream.write(ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)point.getFieldX().getData(), (int)elementLength));
                    stream.write(ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)point.getFieldY().getData(), (int)elementLength));
                    return stream.toByteArray();
                }
                case COMPRESSED: {
                    CyclicGroup<?> group = groupParameters.getGroup();
                    if (!(group instanceof EllipticCurve)) {
                        throw new IllegalArgumentException("Cannot convert Point for non-elliptic curve");
                    }
                    EllipticCurve curve = (EllipticCurve)group;
                    if (curve.createAPointOnCurve(point.getFieldX().getData()).getFieldY().getData().equals(point.getFieldY().getData())) {
                        stream.write(3);
                    } else {
                        stream.write(2);
                    }
                    stream.write(ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)point.getFieldX().getData(), (int)elementLength));
                    return stream.toByteArray();
                }
            }
            throw new UnsupportedOperationException("Unsupported PointFormat: " + String.valueOf((Object)format));
        }
        byte[] coordinate = ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)point.getFieldX().getData(), (int)elementLength);
        stream.write(coordinate);
        return stream.toByteArray();
    }

    public static byte[] toRawFormat(Point point) {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        if (point.isAtInfinity()) {
            return new byte[1];
        }
        int elementLength = ArrayConverter.bigIntegerToByteArray((BigInteger)point.getFieldX().getModulus()).length;
        stream.write(ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)point.getFieldX().getData(), (int)elementLength));
        stream.write(ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)point.getFieldY().getData(), (int)elementLength));
        return stream.toByteArray();
    }

    public static Point fromRawFormat(GroupParameters<?> groupParameters, byte[] pointBytes) {
        CyclicGroup<?> group = groupParameters.getGroup();
        if (!(group instanceof EllipticCurve)) {
            LOGGER.warn("Trying to convert bytes for a non elliptic curve to a Point. Returning null");
            return null;
        }
        Point basePoint = ((EllipticCurve)group).getBasePoint();
        int elementLength = groupParameters.getElementSizeBytes();
        if (pointBytes.length < elementLength * 2) {
            LOGGER.warn("Cannot decode byte[] to point of {}. Returning base point", groupParameters);
            return basePoint;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pointBytes);
        byte[] coordX = new byte[elementLength];
        byte[] coordY = new byte[elementLength];
        try {
            inputStream.read(coordX);
            inputStream.read(coordY);
        }
        catch (IOException ex) {
            LOGGER.warn("Could not read from byteArrayStream. Returning base point", (Throwable)ex);
            return basePoint;
        }
        return ((EllipticCurve)group).getPoint(new BigInteger(1, coordX), new BigInteger(1, coordY));
    }

    public static Point formatFromByteArray(GroupParameters<?> groupParameters, byte[] compressedPoint) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(compressedPoint);
        CyclicGroup<?> group = groupParameters.getGroup();
        if (!(group instanceof EllipticCurve)) {
            LOGGER.warn("Trying to convert bytes for a non elliptic curve to a Point. Returning null");
            return null;
        }
        EllipticCurve curve = (EllipticCurve)group;
        int elementLength = groupParameters.getElementSizeBytes();
        if (compressedPoint.length == 0) {
            LOGGER.warn("Could not parse point. Point is empty. Returning base point");
            return curve.getBasePoint();
        }
        if (groupParameters instanceof NamedEllipticCurveParameters && ((NamedEllipticCurveParameters)groupParameters).getEquationType() == EcCurveEquationType.SHORT_WEIERSTRASS) {
            int pointFormat = inputStream.read();
            byte[] coordX = new byte[elementLength];
            switch (pointFormat) {
                case 2: 
                case 3: {
                    if (compressedPoint.length != elementLength + 1) {
                        LOGGER.warn("Could not parse point. Point needs to be " + (elementLength + 1) + " bytes long, but was " + compressedPoint.length + "bytes long. Returning base point");
                        return curve.getBasePoint();
                    }
                    try {
                        inputStream.read(coordX);
                    }
                    catch (IOException ex) {
                        LOGGER.warn("Could not read from byteArrayStream. Returning base point", (Throwable)ex);
                        return curve.getBasePoint();
                    }
                    Point decompressedPoint = curve.createAPointOnCurve(new BigInteger(1, coordX));
                    if (pointFormat == 2) {
                        decompressedPoint = curve.inverseAffine(decompressedPoint);
                    }
                    return decompressedPoint;
                }
                case 4: {
                    if (compressedPoint.length != elementLength * 2 + 1) {
                        LOGGER.warn("Could not parse point. Point needs to be " + (elementLength * 2 + 1) + " bytes long, but was " + compressedPoint.length + "bytes long. Returning base point");
                        return curve.getBasePoint();
                    }
                    byte[] coordY = new byte[elementLength];
                    try {
                        inputStream.read(coordX);
                        inputStream.read(coordY);
                    }
                    catch (IOException ex) {
                        LOGGER.warn("Could not read from byteArrayStream. Returning base point", (Throwable)ex);
                        return curve.getBasePoint();
                    }
                    return curve.getPoint(new BigInteger(1, coordX), new BigInteger(1, coordY));
                }
            }
            throw new UnsupportedOperationException("Unsupported PointFormat: " + pointFormat);
        }
        if (compressedPoint.length != elementLength) {
            LOGGER.warn("Could not parse point. Point needs to be " + elementLength + " bytes long, but was " + compressedPoint.length + "bytes long. Returning base point");
            return curve.getBasePoint();
        }
        byte[] coordX = new byte[elementLength];
        try {
            inputStream.read(coordX);
        }
        catch (IOException ex) {
            LOGGER.warn("Could not read from byteArrayStream. Returning base point", (Throwable)ex);
            return curve.getBasePoint();
        }
        RFC7748Curve rfc7748Curve = (RFC7748Curve)group;
        return curve.createAPointOnCurve(rfc7748Curve.decodeCoordinate(new BigInteger(1, coordX)));
    }

    public static PointFormat getPointFormat(byte[] encodedPointBytes) {
        if (encodedPointBytes.length == 0) {
            return PointFormat.UNCOMPRESSED;
        }
        return encodedPointBytes[0] == 4 ? PointFormat.UNCOMPRESSED : PointFormat.COMPRESSED;
    }

    private PointFormatter() {
    }
}

