/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.crypto.ec;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.crypto.ec.SimulatedMontgomeryCurve;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class RFC7748Curve
extends SimulatedMontgomeryCurve {
    private static final Logger LOGGER = LogManager.getLogger();

    protected RFC7748Curve(BigInteger a, BigInteger b, BigInteger modulus, BigInteger basePointX, BigInteger basePointY, BigInteger basePointOrder) {
        super(a, b, modulus, basePointX, basePointY, basePointOrder);
    }

    public abstract BigInteger decodeScalar(BigInteger var1);

    public abstract BigInteger decodeCoordinate(BigInteger var1);

    public abstract byte[] encodeCoordinate(BigInteger var1);

    public byte[] computePublicKey(BigInteger privateKey) {
        privateKey = this.reduceLongKey(privateKey);
        BigInteger decodedKey = this.decodeScalar(privateKey);
        Point publicPoint = this.mult(decodedKey, this.getBasePoint());
        return this.encodeCoordinate(publicPoint.getFieldX().getData());
    }

    private byte[] computeSharedSecret(BigInteger privateKey, byte[] publicKey) {
        Point sharedPoint;
        privateKey = this.reduceLongKey(privateKey);
        BigInteger decodedCoord = this.decodeCoordinate(new BigInteger(1, publicKey));
        BigInteger decodedKey = this.decodeScalar(privateKey);
        Point publicPoint = this.createAPointOnCurve(decodedCoord);
        if (publicPoint == null) {
            LOGGER.warn("Could not create a point on curve. Using non-point");
            publicPoint = this.getPoint(BigInteger.ZERO, BigInteger.ZERO);
        }
        if ((sharedPoint = this.mult(decodedKey, publicPoint)).getFieldX() == null) {
            LOGGER.warn("Cannot encode point in infinity. Using X coordinate of base point as shared secret");
            return this.encodeCoordinate(this.getBasePoint().getFieldX().getData());
        }
        return this.encodeCoordinate(sharedPoint.getFieldX().getData());
    }

    public byte[] computeSharedSecretFromDecodedPoint(BigInteger privateKey, Point publicKey) {
        byte[] reEncoded = this.encodeCoordinate(publicKey.getFieldX().getData());
        return this.computeSharedSecret(privateKey, reEncoded);
    }

    public BigInteger reduceLongKey(BigInteger key) {
        byte[] keyBytes = key.toByteArray();
        if (keyBytes.length > ArrayConverter.bigIntegerToByteArray((BigInteger)this.getModulus()).length) {
            keyBytes = Arrays.copyOfRange(keyBytes, 0, ArrayConverter.bigIntegerToByteArray((BigInteger)this.getModulus()).length);
            return new BigInteger(1, keyBytes);
        }
        return key;
    }
}

