/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.crypto.ffdh;

import de.rub.nds.protocol.constants.FfdhGroupParameters;
import de.rub.nds.protocol.crypto.CyclicGroup;
import java.math.BigInteger;

public class FfdhGroup
implements CyclicGroup<BigInteger> {
    private FfdhGroupParameters parameters;

    public FfdhGroup(FfdhGroupParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public BigInteger groupOperation(BigInteger a, BigInteger b) {
        return a.multiply(b);
    }

    @Override
    public BigInteger nTimesGroupOperation(BigInteger a, BigInteger scalar) {
        return a.modPow(scalar, this.parameters.getModulus());
    }

    @Override
    public BigInteger getGenerator() {
        return this.parameters.getGenerator();
    }

    @Override
    public BigInteger nTimesGroupOperationOnGenerator(BigInteger scalar) {
        return this.nTimesGroupOperation(this.parameters.getGenerator(), scalar);
    }

    public BigInteger getModulus() {
        return this.parameters.getModulus();
    }

    public FfdhGroupParameters getParameters() {
        return this.parameters;
    }
}

