/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.crypto.key;

import de.rub.nds.protocol.constants.FfdhGroupParameters;
import de.rub.nds.protocol.constants.NamedEllipticCurveParameters;
import de.rub.nds.protocol.crypto.key.DhPublicKey;
import de.rub.nds.protocol.crypto.key.DsaPublicKey;
import de.rub.nds.protocol.crypto.key.EcdhPublicKey;
import de.rub.nds.protocol.crypto.key.EcdsaPublicKey;
import de.rub.nds.protocol.crypto.key.EddsaPublicKey;
import de.rub.nds.protocol.crypto.key.RsaPrivateKey;
import de.rub.nds.protocol.crypto.key.RsaPublicKey;
import java.math.BigInteger;
import java.util.Random;
import org.apache.commons.lang3.tuple.Pair;

public class KeyGenerator {
    private static final int MAX_NUMBER_OF_DSA_ITERATIONS = 100;

    private KeyGenerator() {
    }

    public static DhPublicKey generateDhPublicKey(BigInteger privateKey, FfdhGroupParameters parameters) {
        return new DhPublicKey(privateKey.modPow(parameters.getGenerator(), parameters.getModulus()), parameters.getGenerator(), parameters.getModulus());
    }

    public static DhPublicKey generateDhPublicKey(BigInteger privateKey, BigInteger generator, BigInteger modulus) {
        return new DhPublicKey(privateKey.modPow(generator, modulus), generator, modulus);
    }

    public static DhPublicKey generateDhPublicKey(BigInteger privateKey, int bitLength, Random random) {
        BigInteger modulus = BigInteger.probablePrime(bitLength, random);
        BigInteger generator = new BigInteger("2");
        return new DhPublicKey(privateKey.modPow(generator, modulus), generator, modulus);
    }

    public static EcdhPublicKey generateEcdhPublicKey(BigInteger privateKey, NamedEllipticCurveParameters parameters) {
        return new EcdhPublicKey(parameters.getGroup().nTimesGroupOperationOnGenerator(privateKey), parameters);
    }

    public static EcdsaPublicKey generateEcdsaPublicKey(BigInteger privateKey, NamedEllipticCurveParameters parameters) {
        return new EcdsaPublicKey(parameters.getGroup().nTimesGroupOperationOnGenerator(privateKey), parameters);
    }

    public static EddsaPublicKey generateEddsaPublicKey(BigInteger privateKey, NamedEllipticCurveParameters parameters) {
        return new EddsaPublicKey(parameters.getGroup().nTimesGroupOperationOnGenerator(privateKey), parameters);
    }

    public static DsaPublicKey generateDsaPublicKey(BigInteger privateKey, int pLength, int qLenght, Random random) {
        BigInteger g;
        BigInteger q;
        BigInteger p = BigInteger.probablePrime(pLength, random);
        int i = 0;
        do {
            q = BigInteger.probablePrime(qLenght, random);
            if (p.subtract(BigInteger.ONE).mod(q).equals(BigInteger.ZERO)) break;
            if (++i <= 100) continue;
            throw new IllegalArgumentException("Could not find a suitable q for the given p");
        } while (p.subtract(BigInteger.ONE).mod(q).equals(BigInteger.ZERO));
        i = 0;
        do {
            BigInteger h = new BigInteger(p.bitLength() - 3, random);
            g = h.modPow(p.subtract(BigInteger.ONE).divide(q), p);
            if (++i <= 100) continue;
            throw new IllegalArgumentException("Could not find a suitable g for the given p and q");
        } while (g == BigInteger.ONE);
        return KeyGenerator.generateDsaPublicKey(privateKey, g, p, q);
    }

    public static DsaPublicKey generateDsaPublicKey(BigInteger privateKey, BigInteger g, BigInteger p, BigInteger q) {
        BigInteger y = g.modPow(privateKey, p);
        return new DsaPublicKey(q, y, g, p);
    }

    public static RsaPublicKey generateRsaPublicKey(BigInteger modulus, BigInteger publicExponent) {
        return new RsaPublicKey(modulus, publicExponent);
    }

    public static Pair<RsaPublicKey, RsaPrivateKey> generateRsaKeys(int bitLength, Random random) {
        return KeyGenerator.generateRsaKeys(new BigInteger("65537"), bitLength, random);
    }

    public static Pair<RsaPublicKey, RsaPrivateKey> generateRsaKeys(BigInteger publicExponent, int bitLength, Random random) {
        BigInteger q;
        BigInteger p;
        BigInteger modulus;
        if (bitLength <= 5) {
            throw new IllegalArgumentException("Bit length must be greater than 5");
        }
        while ((modulus = (p = BigInteger.probablePrime(bitLength / 2, random)).multiply(q = bitLength % 2 == 0 ? BigInteger.probablePrime(bitLength / 2, random) : BigInteger.probablePrime(bitLength / 2 + 1, random))).bitLength() != bitLength) {
        }
        BigInteger phi = p.subtract(BigInteger.ONE).multiply(q.subtract(BigInteger.ONE));
        while (phi.gcd(publicExponent).intValue() > 1) {
            publicExponent = BigInteger.probablePrime(bitLength / 2, random);
        }
        BigInteger privateExponent = publicExponent.modInverse(phi);
        return Pair.of((Object)new RsaPublicKey(publicExponent, modulus), (Object)new RsaPrivateKey(privateExponent, modulus));
    }
}

