/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.crypto.key;

import de.rub.nds.protocol.constants.AsymmetricAlgorithmType;
import de.rub.nds.protocol.crypto.key.PublicKeyContainer;
import java.math.BigInteger;

public class RsaPublicKey
implements PublicKeyContainer {
    private BigInteger publicExponent;
    private BigInteger modulus;

    private RsaPublicKey() {
        this.publicExponent = null;
        this.modulus = null;
    }

    public RsaPublicKey(BigInteger publicExponent, BigInteger modulus) {
        this.publicExponent = publicExponent;
        this.modulus = modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public void setPublicExponent(BigInteger publicExponent) {
        this.publicExponent = publicExponent;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public void setModulus(BigInteger modulus) {
        this.modulus = modulus;
    }

    @Override
    public int length() {
        return this.modulus.bitLength();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.publicExponent == null ? 0 : this.publicExponent.hashCode());
        result = 31 * result + (this.modulus == null ? 0 : this.modulus.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RsaPublicKey other = (RsaPublicKey)obj;
        if (this.publicExponent == null ? other.publicExponent != null : !this.publicExponent.equals(other.publicExponent)) {
            return false;
        }
        return !(this.modulus == null ? other.modulus != null : !this.modulus.equals(other.modulus));
    }

    @Override
    public AsymmetricAlgorithmType getAlgorithmType() {
        return AsymmetricAlgorithmType.RSA;
    }
}

